/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

final class PackagePatternImpl
implements PackagePattern {
    private static final String STATIC_PREFIX = "static ";
    private final String[] parts;
    private final boolean staticc;

    public PackagePatternImpl(String s) {
        this.staticc = s.startsWith(STATIC_PREFIX);
        if (this.staticc) {
            s = s.substring(STATIC_PREFIX.length());
        }
        this.parts = s.split("\\.");
        this.checkParts(s, this.parts);
    }

    private void checkParts(String full, String[] parts) {
        if (full.startsWith(".") || full.endsWith(".")) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains an empty part", full));
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            this.checkCharacters(full, part, i);
        }
    }

    private void checkCharacters(String full, String part, int partIndex) {
        char[] chars = part.toCharArray();
        if (part.isEmpty()) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains an empty part", full));
        }
        if ("*".equals(part) || "**".equals(part)) {
            return;
        }
        if (part.contains("*")) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a part which mixes wildcards and normal characters", full));
        }
        if (partIndex == 0 && "static".equals(part)) {
            return;
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a non-identifier character '%s'", full, Character.valueOf(chars[0])));
        }
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a non-identifier character '%s'", full, Character.valueOf(chars[i])));
        }
    }

    @Override
    public boolean matches(PackagePattern packagePattern) {
        if (packagePattern == this) {
            return true;
        }
        if (packagePattern instanceof PackagePatternImpl) {
            PackagePatternImpl ppi = (PackagePatternImpl)packagePattern;
            return this.matchesInternal(ppi.staticc, ppi.parts, this.staticc, this.parts);
        }
        return this.matches(packagePattern.toString());
    }

    @Override
    public boolean matches(String packageName) {
        boolean matchIsStatic = packageName.startsWith(STATIC_PREFIX);
        if (matchIsStatic) {
            packageName = packageName.substring(STATIC_PREFIX.length());
        }
        String[] matchParts = packageName.split("\\.");
        return this.matchesInternal(matchIsStatic, matchParts, this.staticc, this.parts);
    }

    private boolean matchesInternal(boolean matchIsStatic, String[] matchParts, boolean partsIsStatic, String[] parts) {
        int patternIndex;
        if (matchIsStatic != partsIsStatic) {
            return false;
        }
        if (parts.length > matchParts.length) {
            return false;
        }
        int matchIndex = 0;
        for (patternIndex = 0; patternIndex < parts.length && matchIndex < matchParts.length; ++patternIndex) {
            String patternPart = this.parts[patternIndex];
            String matchPart = matchParts[matchIndex];
            if ("**".equals(patternPart)) {
                if (patternIndex + 1 < parts.length) {
                    String nextPatternPart = parts[patternIndex + 1];
                    while (matchIndex < matchParts.length && !PackagePatternImpl.matchParts(nextPatternPart, matchParts[matchIndex])) {
                        ++matchIndex;
                    }
                    continue;
                }
                matchIndex = matchParts.length;
                continue;
            }
            if (PackagePatternImpl.matchParts(patternPart, matchPart)) {
                ++matchIndex;
                continue;
            }
            return false;
        }
        return patternIndex == parts.length && matchIndex == matchParts.length;
    }

    private static boolean matchParts(String patternPart, String matchPart) {
        if ("*".equals(patternPart) || "**".equals(patternPart)) {
            return true;
        }
        return patternPart.equals(matchPart);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.staticc) {
            result.append(STATIC_PREFIX);
        }
        result.append(Arrays.stream(this.parts).collect(Collectors.joining(".")));
        return result.toString();
    }

    @Override
    public int compareTo(PackagePattern other) {
        PackagePatternImpl o = (PackagePatternImpl)other;
        if (this.isMoreSpecificThan(o)) {
            return 1;
        }
        if (o.isMoreSpecificThan(this)) {
            return -1;
        }
        return 0;
    }

    private boolean isMoreSpecificThan(PackagePattern other) {
        int numOfStarOther;
        int numOfStarStarOther;
        PackagePatternImpl o = (PackagePatternImpl)other;
        int numOfStarStarThis = this.count("**", this.parts);
        if (numOfStarStarThis < (numOfStarStarOther = this.count("**", o.parts))) {
            return true;
        }
        if (numOfStarStarThis > numOfStarStarOther) {
            return false;
        }
        int numOfStarThis = this.count("*", this.parts);
        if (numOfStarThis < (numOfStarOther = this.count("*", o.parts))) {
            return true;
        }
        if (numOfStarOther > numOfStarThis) {
            return false;
        }
        String thisLastPart = this.parts[this.parts.length - 1];
        String otherLastPart = o.parts[o.parts.length - 1];
        if (thisLastPart.equals("**")) {
            return this.parts.length > o.parts.length;
        }
        if (thisLastPart.equals("*")) {
            return otherLastPart.equals("**");
        }
        return this.parts.length > o.parts.length;
    }

    private int count(String s, String[] arr) {
        return (int)Arrays.stream(arr).filter(s::equals).count();
    }

    @Override
    public boolean isStatic() {
        return this.staticc;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.parts), this.staticc);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PackagePatternImpl && this.staticc == ((PackagePatternImpl)obj).staticc && Arrays.equals(this.parts, ((PackagePatternImpl)obj).parts);
    }
}

