/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzerSettings;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.ImportMatcherImpl;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.RuntimeIOException;
import de.skuzzle.enforcer.restrictimports.analyze.SkipCommentsLineSupplier;
import de.skuzzle.enforcer.restrictimports.analyze.SourceTreeAnalyzer;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class SourceTreeAnalyzerImpl
implements SourceTreeAnalyzer {
    SourceTreeAnalyzerImpl() {
    }

    @Override
    public AnalyzeResult analyze(AnalyzerSettings settings, BannedImportGroups groups) {
        SkipCommentsLineSupplier lineSupplier = new SkipCommentsLineSupplier(settings.getSourceFileCharset(), settings.getCommentLineBufferSize());
        ImportMatcherImpl importMatcher = new ImportMatcherImpl(lineSupplier);
        ArrayList<MatchedFile> matchedFiles = new ArrayList<MatchedFile>();
        Collection<Path> rootsIterable = settings.getRootDirectories();
        for (Path root : rootsIterable) {
            this.listFiles(root, this::isJavaSourceFile).map(sourceFile -> importMatcher.matchFile((Path)sourceFile, groups)).filter(Optional::isPresent).map(Optional::get).forEach(matchedFiles::add);
        }
        return AnalyzeResult.builder().withMatches(matchedFiles).build();
    }

    private Stream<Path> listFiles(Path root, Predicate<Path> filter) {
        try {
            if (!Files.exists(root, new LinkOption[0])) {
                return Stream.empty();
            }
            return Files.find(root, Integer.MAX_VALUE, (path, bfa) -> filter.test((Path)path), new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Encountered IOException while listing files of " + root, e);
        }
    }

    private boolean isFile(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]);
    }

    private boolean isJavaSourceFile(Path path) {
        return this.isFile(path) && path.getFileName().toString().toLowerCase().endsWith(".java");
    }
}

