/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.internal.DefaultHttpClientFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class CachingHttpClientFactory
extends DefaultHttpClientFactory {
    private Map<HttpHost, CloseableHttpClient> cachedAcceptingClients = new HashMap<HttpHost, CloseableHttpClient>();
    private Map<HttpHost, CloseableHttpClient> cachedClients = new HashMap<HttpHost, CloseableHttpClient>();

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate) {
        CloseableHttpClient c = acceptAnyCertificate ? this.cachedAcceptingClients.get(httpHost) : this.cachedClients.get(httpHost);
        if (c == null) {
            c = super.createHttpClient(httpHost, acceptAnyCertificate);
            if (acceptAnyCertificate) {
                this.cachedAcceptingClients.put(httpHost, c);
            } else {
                this.cachedClients.put(httpHost, c);
            }
        }
        return c;
    }

    public void close() throws IOException {
        for (CloseableHttpClient c : this.cachedAcceptingClients.values()) {
            c.close();
        }
        this.cachedAcceptingClients.clear();
        for (CloseableHttpClient c : this.cachedClients.values()) {
            c.close();
        }
        this.cachedClients.clear();
    }
}

