/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.internal.ContentEncodingNoneInterceptor;
import de.undercouch.gradle.tasks.download.internal.HttpClientFactory;
import de.undercouch.gradle.tasks.download.internal.InsecureHostnameVerifier;
import de.undercouch.gradle.tasks.download.internal.InsecureTrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private SSLConnectionSocketFactory insecureSSLSocketFactory = null;

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(null));
        if ("https".equals(httpHost.getSchemeName()) && acceptAnyCertificate) {
            SSLConnectionSocketFactory icsf = this.getInsecureSSLSocketFactory();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)icsf);
            Registry registry = RegistryBuilder.create().register("https", (Object)icsf).build();
            BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager((Lookup)registry);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        builder.addInterceptorFirst((HttpResponseInterceptor)new ContentEncodingNoneInterceptor());
        CloseableHttpClient client = builder.build();
        return client;
    }

    private SSLConnectionSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = new SSLConnectionSocketFactory(sc, INSECURE_HOSTNAME_VERIFIER);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }
}

