/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.tools.ajc.Main;
import org.codehaus.mojo.aspectj.AbstractAjcMojo;
import org.codehaus.mojo.aspectj.AjcHelper;
import org.codehaus.mojo.aspectj.CompilationFailedException;
import org.codehaus.mojo.aspectj.MavenMessageHandler;
import org.codehaus.mojo.aspectj.Module;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAjcCompiler
extends AbstractAjcMojo {
    public static final List<String> XAJRUNTIMETARGET_SUPPORTED_VALUES = Arrays.asList("1.2", "1.5");
    @Parameter(defaultValue="src/main/aspect")
    protected String aspectDirectory = "src/main/aspect";
    @Parameter(defaultValue="src/test/aspect")
    protected String testAspectDirectory = "src/test/aspect";
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter
    protected String ajdtBuildDefFile;
    @Parameter
    protected boolean outxml;
    @Parameter
    protected String outxmlfile;
    @Parameter
    protected boolean emacssym;
    @Parameter
    protected String proc;
    @Parameter
    protected boolean parameters;
    @Parameter
    protected Map<String, String> Xset;
    @Parameter
    protected boolean crossrefs;
    @Parameter
    protected String Xlint;
    @Parameter
    protected File Xlintfile;
    @Parameter
    protected boolean XhasMember;
    @Parameter
    protected String source;
    @Parameter
    protected String target;
    @Parameter
    protected String complianceLevel;
    @Parameter
    protected String release;
    @Parameter
    protected boolean deprecation;
    @Parameter
    protected boolean noImportError;
    @Parameter
    protected boolean proceedOnError;
    @Parameter
    protected boolean preserveAllLocals;
    @Parameter
    protected boolean referenceInfo;
    @Parameter(property="project.build.sourceEncoding")
    protected String encoding;
    @Parameter
    protected boolean verbose;
    @Parameter
    protected boolean showWeaveInfo;
    @Parameter
    protected int repeat;
    @Parameter
    protected boolean Xreweavable;
    @Parameter
    protected boolean XnotReweavable;
    @Parameter
    protected boolean XnoInline;
    @Parameter
    protected boolean XserializableAspects;
    @Parameter
    protected boolean XaddSerialVersionUID;
    @Parameter
    protected boolean XterminateAfterCompilation;
    @Parameter(defaultValue="1.5")
    protected String Xajruntimetarget;
    @Parameter
    protected String Xjoinpoints;
    @Parameter
    protected String bootclasspath;
    @Parameter
    protected String warn;
    @Parameter(defaultValue="builddef.lst")
    protected String argumentFileName = "builddef.lst";
    @Parameter(defaultValue="false")
    protected boolean forceAjcCompile;
    @Parameter
    protected List<String> additionalCompilerArgs = new ArrayList<String>();
    @Parameter(defaultValue="false")
    protected boolean enablePreview;
    protected List<String> ajcOptions = new ArrayList<String>();
    protected Set<String> resolvedIncludes;
    private static final Object BIG_ASPECTJ_LOCK = new Object();

    protected abstract List<String> getClasspathDirectories();

    protected abstract File getOutputDirectory();

    protected abstract File getGeneratedSourcesDirectory();

    protected abstract List<String> getSourceDirectories();

    protected abstract Scanner[] getJavaSources();

    protected abstract String getAdditionalAspectPaths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipping execution because of 'skip' option");
            }
            return;
        }
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!this.forceAjcCompile && !"java".equalsIgnoreCase(artifactHandler.getLanguage())) {
            this.getLog().warn((CharSequence)"Not executing aspectJ compiler as the project is not a Java classpath-capable package");
            return;
        }
        File aspectSourcePathDir = FileUtils.resolveFile((File)this.basedir, (String)this.aspectDirectory);
        File testAspectSourcePathDir = FileUtils.resolveFile((File)this.basedir, (String)this.testAspectDirectory);
        String aspectSourcePath = aspectSourcePathDir.getAbsolutePath();
        String testAspectSourcePath = testAspectSourcePathDir.getAbsolutePath();
        if (aspectSourcePathDir.exists() && aspectSourcePathDir.isDirectory() && !this.project.getCompileSourceRoots().contains(aspectSourcePath)) {
            this.getLog().debug((CharSequence)("Adding existing aspectSourcePathDir [" + aspectSourcePath + "] to compileSourceRoots."));
            this.project.getCompileSourceRoots().add(aspectSourcePath);
        } else {
            this.getLog().debug((CharSequence)("Not adding non-existent or already added aspectSourcePathDir [" + aspectSourcePath + "] to compileSourceRoots."));
        }
        if (testAspectSourcePathDir.exists() && testAspectSourcePathDir.isDirectory() && !this.project.getTestCompileSourceRoots().contains(testAspectSourcePath)) {
            this.getLog().debug((CharSequence)("Adding existing testAspectSourcePathDir [" + testAspectSourcePath + "] to testCompileSourceRoots."));
            this.project.getTestCompileSourceRoots().add(testAspectSourcePath);
        } else {
            this.getLog().debug((CharSequence)("Not adding non-existent or already added testAspectSourcePathDir [" + testAspectSourcePath + "] to testCompileSourceRoots."));
        }
        this.assembleArguments();
        if (!this.forceAjcCompile && !this.hasSourcesToCompile()) {
            this.getLog().warn((CharSequence)"No sources found skipping aspectJ compile");
            return;
        }
        if (!this.forceAjcCompile && !this.isBuildNeeded()) {
            this.getLog().info((CharSequence)"No modifications found skipping aspectJ compile");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            StringBuilder command = new StringBuilder("Running : ajc");
            for (String string : this.ajcOptions) {
                command.append(' ').append(string);
            }
            this.getLog().debug((CharSequence)command);
        }
        try {
            this.getLog().debug((CharSequence)("Compiling and weaving " + this.resolvedIncludes.size() + " sources to " + this.getOutputDirectory()));
            AjcHelper.writeBuildConfigToFile(this.ajcOptions, this.argumentFileName, this.getOutputDirectory());
            this.getLog().debug((CharSequence)("Arguments file written : " + new File(this.getOutputDirectory(), this.argumentFileName).getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write arguments file to the target area", (Exception)e);
        }
        Main ajcMain = new Main();
        MavenMessageHandler mavenMessageHandler = new MavenMessageHandler(this.getLog());
        ajcMain.setHolder((IMessageHolder)mavenMessageHandler);
        Object object = BIG_ASPECTJ_LOCK;
        synchronized (object) {
            ajcMain.runMain(this.ajcOptions.toArray(new String[0]), false);
        }
        IMessage[] iMessageArray = mavenMessageHandler.getMessages(IMessage.ERROR, true);
        if (!this.proceedOnError && iMessageArray.length > 0) {
            throw CompilationFailedException.create(iMessageArray);
        }
    }

    protected void assembleArguments() throws MojoExecutionException {
        if (AjcHelper.isValidComplianceLevel(this.release)) {
            this.ajcOptions.add("--release");
            this.ajcOptions.add(this.release);
        } else if (AjcHelper.isValidComplianceLevel(this.complianceLevel)) {
            this.ajcOptions.add("-" + this.complianceLevel);
        } else {
            if (AjcHelper.isValidComplianceLevel(this.source)) {
                this.ajcOptions.add("-source");
                this.ajcOptions.add(this.source);
            }
            if (AjcHelper.isValidComplianceLevel(this.target)) {
                this.ajcOptions.add("-target");
                this.ajcOptions.add(this.target);
            }
        }
        if (this.XhasMember) {
            this.ajcOptions.add("-XhasMember");
        }
        this.ajcOptions.add("-classpath");
        this.ajcOptions.add(AjcHelper.createClassPath(this.project, null, this.getClasspathDirectories()));
        if (null != this.bootclasspath) {
            this.ajcOptions.add("-bootclasspath");
            this.ajcOptions.add(this.bootclasspath);
        }
        if (null != this.Xjoinpoints) {
            this.ajcOptions.add("-Xjoinpoints:" + this.Xjoinpoints);
        }
        if (null != this.warn) {
            this.ajcOptions.add("-warn:" + this.warn);
        }
        if (null != this.proc) {
            this.ajcOptions.add("-proc:" + this.proc);
        }
        if (this.Xset != null && !this.Xset.isEmpty()) {
            StringBuilder sb = new StringBuilder("-Xset:");
            for (Map.Entry<String, String> param : this.Xset.entrySet()) {
                sb.append(param.getKey());
                sb.append("=");
                sb.append(param.getValue());
                sb.append(',');
            }
            this.ajcOptions.add(sb.substring(0, sb.length() - 1));
        }
        String joinedWeaveDirectories = null;
        if (this.weaveDirectories != null) {
            joinedWeaveDirectories = StringUtils.join((Object[])this.weaveDirectories, (String)File.pathSeparator);
        }
        this.addModulesArgument("-inpath", this.ajcOptions, this.weaveDependencies, joinedWeaveDirectories, "dependencies and/or directories to weave");
        this.addModulesArgument("-aspectpath", this.ajcOptions, this.aspectLibraries, this.getAdditionalAspectPaths(), "an aspect library");
        this.addModulesArgument("--module-path", this.ajcOptions, this.javaModules, null, "Java module");
        if (null != this.xmlConfigured) {
            this.ajcOptions.add("-xmlConfigured");
            this.ajcOptions.add(this.xmlConfigured.getAbsolutePath());
        }
        this.ajcOptions.add("-d");
        this.ajcOptions.add(this.getOutputDirectory().getAbsolutePath());
        this.ajcOptions.add("-s");
        this.ajcOptions.add(this.getGeneratedSourcesDirectory().getAbsolutePath());
        this.resolvedIncludes = null != this.ajdtBuildDefFile ? AjcHelper.getBuildFilesForAjdtFile(this.ajdtBuildDefFile, this.basedir) : this.getIncludedSources();
        this.ajcOptions.addAll(this.resolvedIncludes);
        if (CollectionUtils.isNotEmpty(this.additionalCompilerArgs)) {
            this.ajcOptions.addAll(this.additionalCompilerArgs);
        }
    }

    protected Set<String> getIncludedSources() throws MojoExecutionException {
        HashSet<String> result = new HashSet();
        if (this.getJavaSources() == null) {
            result = AjcHelper.getBuildFilesForSourceDirs(this.getSourceDirectories(), this.includes, this.excludes);
        } else {
            for (int scannerIndex = 0; scannerIndex < this.getJavaSources().length; ++scannerIndex) {
                Scanner scanner = this.getJavaSources()[scannerIndex];
                if (scanner.getBasedir() == null) {
                    this.getLog().info((CharSequence)"Source without basedir, skipping it.");
                    continue;
                }
                scanner.scan();
                for (int fileIndex = 0; fileIndex < scanner.getIncludedFiles().length; ++fileIndex) {
                    result.add(FileUtils.resolveFile((File)scanner.getBasedir(), (String)scanner.getIncludedFiles()[fileIndex]).getAbsolutePath());
                }
            }
        }
        return result;
    }

    private void addModulesArgument(String argument, List<String> arguments, Module[] modules, String aditionalpath, String role) throws MojoExecutionException {
        StringBuilder buf = new StringBuilder();
        if (null != aditionalpath) {
            arguments.add(argument);
            buf.append(aditionalpath);
        }
        if (modules != null && modules.length > 0) {
            if (!arguments.contains(argument)) {
                arguments.add(argument);
            }
            for (Module module : modules) {
                Artifact artifact = null;
                Set allArtifacts = this.project.getArtifacts();
                for (Artifact art : allArtifacts) {
                    if (!art.getGroupId().equals(module.getGroupId()) || !art.getArtifactId().equals(module.getArtifactId()) || !StringUtils.defaultString((Object)module.getClassifier()).equals(StringUtils.defaultString((Object)art.getClassifier())) || !StringUtils.defaultString((Object)module.getType(), (String)"jar").equals(StringUtils.defaultString((Object)art.getType()))) continue;
                    artifact = art;
                    break;
                }
                if (artifact == null) {
                    throw new MojoExecutionException("The artifact " + module.toString() + " referenced in aspectj plugin as " + role + ", is not found the project dependencies");
                }
                if (buf.length() != 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(artifact.getFile().getPath());
            }
        }
        if (buf.length() > 0) {
            String pathString = buf.toString();
            arguments.add(pathString);
            this.getLog().debug((CharSequence)("Adding " + argument + ": " + pathString));
        }
    }

    protected boolean isBuildNeeded() throws MojoExecutionException {
        File outDir = this.getOutputDirectory();
        return this.hasNoPreviousBuild(outDir) || this.hasArgumentsChanged(outDir) || this.hasSourcesChanged(outDir) || this.hasNonWeavedClassesChanged(outDir);
    }

    private boolean hasNoPreviousBuild(File outDir) {
        return !FileUtils.resolveFile((File)outDir, (String)this.argumentFileName).exists();
    }

    private boolean hasArgumentsChanged(File outDir) throws MojoExecutionException {
        try {
            return !this.ajcOptions.equals(AjcHelper.readBuildConfigFile(this.argumentFileName, outDir));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during reading of previous argumentsfile ");
        }
    }

    private boolean hasSourcesToCompile() {
        return this.resolvedIncludes.size() > 0;
    }

    private boolean hasSourcesChanged(File outDir) {
        long lastBuild = new File(outDir, this.argumentFileName).lastModified();
        for (String source : this.resolvedIncludes) {
            File sourceFile = new File(source);
            long sourceModified = sourceFile.lastModified();
            if (sourceModified < lastBuild) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonWeavedClassesChanged(File outDir) throws MojoExecutionException {
        if (this.weaveDirectories != null && this.weaveDirectories.length > 0) {
            Set<String> weaveSources = AjcHelper.getWeaveSourceFiles(this.weaveDirectories);
            long lastBuild = new File(outDir, this.argumentFileName).lastModified();
            for (String source : weaveSources) {
                File sourceFile = new File(source);
                long sourceModified = sourceFile.lastModified();
                if (sourceModified < lastBuild) continue;
                return true;
            }
        }
        return false;
    }

    public void setDeprecation(boolean deprecation) {
        if (deprecation) {
            this.ajcOptions.add("-deprecation");
        }
    }

    public void setEmacssym(boolean emacssym) {
        if (emacssym) {
            this.ajcOptions.add("-emacssym");
        }
    }

    public void setParameters(boolean parameters) {
        if (parameters) {
            this.ajcOptions.add("-parameters");
        }
    }

    public void setCrossrefs(boolean crossrefs) {
        if (crossrefs) {
            this.ajcOptions.add("-crossrefs");
        }
    }

    public void setEncoding(String encoding) {
        this.ajcOptions.add("-encoding");
        this.ajcOptions.add(encoding);
    }

    public void setNoImportError(boolean noImportError) {
        if (noImportError) {
            this.ajcOptions.add("-noImportError");
        }
    }

    public void setOutxml(boolean outxml) {
        if (outxml) {
            this.ajcOptions.add("-outxml");
        }
    }

    public void setOutxmlfile(String outxmlfile) {
        this.ajcOptions.add("-outxmlfile");
        this.ajcOptions.add(outxmlfile);
    }

    public void setPreserveAllLocals(boolean preserveAllLocals) {
        if (preserveAllLocals) {
            this.ajcOptions.add("-preserveAllLocals");
        }
    }

    public void setProceedOnError(boolean proceedOnError) {
        if (proceedOnError) {
            this.ajcOptions.add("-proceedOnError");
        }
        this.proceedOnError = proceedOnError;
    }

    public void setReferenceInfo(boolean referenceInfo) {
        if (referenceInfo) {
            this.ajcOptions.add("-referenceInfo");
        }
    }

    public void setRepeat(int repeat) {
        this.ajcOptions.add("-repeat");
        this.ajcOptions.add("" + repeat);
    }

    public void setShowWeaveInfo(boolean showWeaveInfo) {
        if (showWeaveInfo) {
            this.ajcOptions.add("-showWeaveInfo");
        }
    }

    public void setEnablePreview(boolean enablePreview) {
        if (enablePreview) {
            this.ajcOptions.add("--enable-preview");
        }
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.ajcOptions.add("-verbose");
        }
    }

    public void setXhasMember(boolean xhasMember) {
        this.XhasMember = xhasMember;
    }

    public void setXlint(String xlint) {
        this.ajcOptions.add("-Xlint:" + xlint);
    }

    public void setXset(Map<String, String> xset) {
        this.Xset = xset;
    }

    public void setXlintfile(File xlintfile) {
        try {
            String prefix = "Xlintfile parameter invalid: ";
            String path = xlintfile.getCanonicalPath();
            if (!xlintfile.exists()) {
                this.getLog().warn((CharSequence)("Xlintfile parameter invalid:  file [" + path + "] does not exist"));
            } else if (xlintfile.isDirectory()) {
                this.getLog().warn((CharSequence)("Xlintfile parameter invalid:  given path [" + path + "] is a directory."));
            } else if (!path.trim().toLowerCase().endsWith(".properties")) {
                this.getLog().warn((CharSequence)"Xlintfile parameter invalid:  must be a .properties file");
            } else {
                this.ajcOptions.add("-Xlintfile");
                this.ajcOptions.add(path);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"IOException while setting Xlintfile option", (Throwable)e);
        }
    }

    public void setXnoInline(boolean xnoInline) {
        if (xnoInline) {
            this.ajcOptions.add("-XnoInline");
        }
    }

    public void setXreweavable(boolean xreweavable) {
        if (xreweavable) {
            this.ajcOptions.add("-Xreweavable");
        }
    }

    public void setXnotReweavable(boolean xnotReweavable) {
        if (xnotReweavable) {
            this.ajcOptions.add("-XnotReweavable");
        }
    }

    public void setXserializableAspects(boolean xserializableAspects) {
        if (xserializableAspects) {
            this.ajcOptions.add("-XserializableAspects");
        }
    }

    public void setXaddSerialVersionUID(boolean xaddSerialVersionUID) {
        if (xaddSerialVersionUID) {
            this.ajcOptions.add("-XaddSerialVersionUID");
        }
    }

    public void setXterminateAfterCompilation(boolean xterminateAfterCompilation) {
        if (xterminateAfterCompilation) {
            this.ajcOptions.add("-XterminateAfterCompilation");
        }
    }

    public void setXajruntimetarget(String xajruntimetarget) {
        if (XAJRUNTIMETARGET_SUPPORTED_VALUES.contains(xajruntimetarget)) {
            this.ajcOptions.add("-Xajruntimetarget:" + xajruntimetarget);
        } else {
            this.getLog().warn((CharSequence)("Incorrect Xajruntimetarget value specified. Supported: " + XAJRUNTIMETARGET_SUPPORTED_VALUES));
        }
    }

    public void setBootClassPath(String bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public void setXjoinpoints(String xjoinpoints) {
        this.Xjoinpoints = xjoinpoints;
    }

    public void setWarn(String warn) {
        this.warn = warn;
    }

    public void setArgumentFileName(String argumentFileName) {
        this.argumentFileName = argumentFileName;
    }
}

