/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.auth;

import com.vaadin.flow.internal.springcsrf.SpringCsrfTokenUtil;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import dev.hilla.auth.EndpointAccessChecker;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CsrfChecker {
    private static final String VAADIN_CSRF_TOKEN_HEADER_NAME = "X-CSRF-Token";
    private static final String VAADIN_CSRF_COOKIE_NAME = "csrfToken";
    private boolean csrfProtectionEnabled = true;

    public CsrfChecker(ServletContext servletContext) {
        try {
            ApplicationConfiguration cfg = ApplicationConfiguration.get((VaadinContext)new VaadinServletContext(servletContext));
            if (cfg != null) {
                this.setCsrfProtection(cfg.isXsrfProtectionEnabled());
            }
        }
        catch (Exception e) {
            CsrfChecker.getLogger().debug("Failed to fetch ApplicationConfiguration", (Throwable)e);
        }
    }

    public boolean validateCsrfTokenInRequest(HttpServletRequest request) {
        if (this.isSpringCsrfTokenPresent((ServletRequest)request)) {
            return true;
        }
        if (!this.isCsrfProtectionEnabled()) {
            return true;
        }
        String csrfTokenInCookie = this.getCsrfTokenInCookie(request);
        if (csrfTokenInCookie == null) {
            if (CsrfChecker.getLogger().isInfoEnabled()) {
                CsrfChecker.getLogger().info("Unable to verify CSRF token for endpoint request, got null token in cookie");
            }
            return false;
        }
        String csrfTokenInRequest = this.getCsrfTokenInRequest(request);
        if (this.compareCsrfTokens(csrfTokenInCookie, csrfTokenInRequest)) {
            if (CsrfChecker.getLogger().isInfoEnabled()) {
                CsrfChecker.getLogger().info("Invalid CSRF token in endpoint request");
            }
            return false;
        }
        return true;
    }

    private boolean compareCsrfTokens(String csrfTokenInCookie, String csrfTokenInRequest) {
        return csrfTokenInRequest == null || !MessageDigest.isEqual(csrfTokenInCookie.getBytes(StandardCharsets.UTF_8), csrfTokenInRequest.getBytes(StandardCharsets.UTF_8));
    }

    String getCsrfTokenInRequest(HttpServletRequest request) {
        return request.getHeader(VAADIN_CSRF_TOKEN_HEADER_NAME);
    }

    String getCsrfTokenInCookie(HttpServletRequest request) {
        return Optional.ofNullable(request.getCookies()).map(Arrays::stream).orElse(Stream.empty()).filter(cookie -> cookie.getName().equals(VAADIN_CSRF_COOKIE_NAME)).findFirst().map(Cookie::getValue).orElse(null);
    }

    public void setCsrfProtection(boolean csrfProtectionEnabled) {
        this.csrfProtectionEnabled = csrfProtectionEnabled;
    }

    public boolean isCsrfProtectionEnabled() {
        return this.csrfProtectionEnabled;
    }

    boolean isSpringCsrfTokenPresent(ServletRequest request) {
        return SpringCsrfTokenUtil.getSpringCsrfToken((ServletRequest)request).isPresent();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EndpointAccessChecker.class);
    }
}

