/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorConfiguration;
import dev.hilla.engine.ParserConfiguration;
import dev.hilla.maven.EngineConfigureMojoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="configure", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class EngineConfigureMojo
extends AbstractMojo {
    @Parameter(readonly=true)
    private final GeneratorConfiguration generator = new GeneratorConfiguration();
    @Parameter(readonly=true)
    private final ParserConfiguration parser = new ParserConfiguration();
    @Parameter(defaultValue="${project.basedir}/frontend/generated")
    private File generatedTsFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws EngineConfigureMojoException {
        try {
            String buildDir = this.project.getBuild().getDirectory();
            EngineConfiguration conf = new EngineConfiguration.Builder(this.project.getBasedir().toPath()).classPath(new LinkedHashSet(this.project.getRuntimeClasspathElements())).outputDir(this.generatedTsFolder.toPath()).generator(this.generator).parser(this.parser).buildDir(buildDir).classesDir(this.project.getBuild().getOutputDirectory()).create();
            Path configDir = this.project.getBasedir().toPath().resolve(buildDir);
            Files.createDirectories(configDir, new FileAttribute[0]);
            conf.store(configDir.resolve("hilla-engine-configuration.json").toFile());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new EngineConfigureMojoException("Configuration failed", e);
        }
        catch (IOException e) {
            throw new EngineConfigureMojoException("Maven configuration has not been saved to file", e);
        }
    }
}

