/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.message.client.EnvelopeClientMessage;
import dev.miku.r2dbc.mysql.message.client.HandshakeResponse;
import dev.miku.r2dbc.mysql.message.client.SslRequest41;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;

final class HandshakeResponse41
extends EnvelopeClientMessage
implements HandshakeResponse {
    private static final int ONE_BYTE_MAX_INT = 255;
    private final SslRequest41 head;
    private final String user;
    private final byte[] authentication;
    private final String authType;
    private final String database;
    private final Map<String, String> attributes;

    HandshakeResponse41(int capabilities, int collationId, String user, byte[] authentication, String authType, String database, Map<String, String> attributes) {
        this.head = new SslRequest41(capabilities, collationId);
        this.user = AssertUtils.requireNonNull(user, "user must not be null");
        this.authentication = AssertUtils.requireNonNull(authentication, "authentication must not be null");
        this.database = AssertUtils.requireNonNull(database, "database must not be null");
        this.authType = AssertUtils.requireNonNull(authType, "authType must not be null");
        this.attributes = AssertUtils.requireNonNull(attributes, "attributes must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeResponse41)) {
            return false;
        }
        HandshakeResponse41 that = (HandshakeResponse41)o;
        if (!this.head.equals(that.head)) {
            return false;
        }
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!Arrays.equals(this.authentication, that.authentication)) {
            return false;
        }
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        if (!this.database.equals(that.database)) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        int result = this.head.hashCode();
        result = 31 * result + this.user.hashCode();
        result = 31 * result + Arrays.hashCode(this.authentication);
        result = 31 * result + this.authType.hashCode();
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }

    public String toString() {
        return String.format("HandshakeResponse41{capabilities=%x, collationId=%d, user='%s', authentication=REDACTED, authType='%s', database='%s', attributes=%s}", this.head.getCapabilities(), this.head.getCollationId(), this.user, this.authType, this.database, this.attributes);
    }

    @Override
    protected void writeTo(ByteBuf buf, ConnectionContext context) {
        this.head.writeTo(buf);
        int capabilities = this.head.getCapabilities();
        Charset charset = context.getClientCollation().getCharset();
        HandshakeResponse.writeCString(buf, this.user, charset);
        if ((capabilities & 0x200000) != 0) {
            HandshakeResponse41.writeVarIntSizedBytes(buf, this.authentication);
        } else if (this.authentication.length <= 255) {
            buf.writeByte(this.authentication.length).writeBytes(this.authentication);
        } else {
            buf.writeByte(0);
        }
        if ((capabilities & 8) != 0) {
            HandshakeResponse.writeCString(buf, this.database, charset);
        }
        if ((capabilities & 0x80000) != 0) {
            HandshakeResponse.writeCString(buf, this.authType, StandardCharsets.UTF_8);
        }
        if ((capabilities & 0x100000) != 0) {
            this.writeAttrs(buf, charset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAttrs(ByteBuf buf, Charset charset) {
        if (this.attributes.isEmpty()) {
            buf.writeByte(0);
            return;
        }
        ByteBuf attributesBuf = buf.alloc().buffer();
        try {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                HandshakeResponse41.writeVarIntString(attributesBuf, entry.getKey(), charset);
                HandshakeResponse41.writeVarIntString(attributesBuf, entry.getValue(), charset);
            }
            HandshakeResponse41.writeVarIntSizedBytes(buf, attributesBuf);
        }
        finally {
            attributesBuf.release();
        }
    }

    private static void writeVarIntString(ByteBuf buf, String value, Charset charset) {
        if (value.isEmpty()) {
            buf.writeByte(0);
            return;
        }
        HandshakeResponse41.writeVarIntSizedBytes(buf, value.getBytes(charset));
    }

    private static void writeVarIntSizedBytes(ByteBuf buf, byte[] value) {
        int size = value.length;
        if (size == 0) {
            buf.writeByte(0);
            return;
        }
        VarIntUtils.writeVarInt(buf, size);
        buf.writeBytes(value);
    }

    private static void writeVarIntSizedBytes(ByteBuf buf, ByteBuf value) {
        int size = value.readableBytes();
        if (size == 0) {
            buf.writeByte(0);
            return;
        }
        VarIntUtils.writeVarInt(buf, size);
        buf.writeBytes(value);
    }
}

