/*
 * Decompiled with CFR 0.152.
 */
package com.tschuchort.compiletesting;

import com.tschuchort.compiletesting.CompilationResult;
import com.tschuchort.compiletesting.DiagnosticMessage;
import com.tschuchort.compiletesting.KotlinCompilation;
import com.tschuchort.compiletesting.KotlinJsCompilation;
import com.tschuchort.compiletesting.UtilsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.ExperimentalCompilerApi;

@ExperimentalCompilerApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/tschuchort/compiletesting/JsCompilationResult;", "Lcom/tschuchort/compiletesting/CompilationResult;", "exitCode", "Lcom/tschuchort/compiletesting/KotlinCompilation$ExitCode;", "messages", "", "diagnosticMessages", "", "Lcom/tschuchort/compiletesting/DiagnosticMessage;", "compilation", "Lcom/tschuchort/compiletesting/KotlinJsCompilation;", "<init>", "(Lcom/tschuchort/compiletesting/KotlinCompilation$ExitCode;Ljava/lang/String;Ljava/util/List;Lcom/tschuchort/compiletesting/KotlinJsCompilation;)V", "getExitCode", "()Lcom/tschuchort/compiletesting/KotlinCompilation$ExitCode;", "getMessages", "()Ljava/lang/String;", "getDiagnosticMessages", "()Ljava/util/List;", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "jsFiles", "getJsFiles", "core"})
public final class JsCompilationResult
implements CompilationResult {
    @NotNull
    private final KotlinCompilation.ExitCode exitCode;
    @NotNull
    private final String messages;
    @NotNull
    private final List<DiagnosticMessage> diagnosticMessages;
    @NotNull
    private final KotlinJsCompilation compilation;
    @NotNull
    private final List<File> jsFiles;

    public JsCompilationResult(@NotNull KotlinCompilation.ExitCode exitCode, @NotNull String messages, @NotNull List<DiagnosticMessage> diagnosticMessages, @NotNull KotlinJsCompilation compilation) {
        Intrinsics.checkNotNullParameter((Object)((Object)exitCode), (String)"exitCode");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        Intrinsics.checkNotNullParameter(diagnosticMessages, (String)"diagnosticMessages");
        Intrinsics.checkNotNullParameter((Object)compilation, (String)"compilation");
        this.exitCode = exitCode;
        this.messages = messages;
        this.diagnosticMessages = diagnosticMessages;
        this.compilation = compilation;
        this.jsFiles = UtilsKt.listFilesRecursively(this.getOutputDirectory());
    }

    @Override
    @NotNull
    public KotlinCompilation.ExitCode getExitCode() {
        return this.exitCode;
    }

    @Override
    @NotNull
    public String getMessages() {
        return this.messages;
    }

    @Override
    @NotNull
    public List<DiagnosticMessage> getDiagnosticMessages() {
        return this.diagnosticMessages;
    }

    @Override
    @NotNull
    public File getOutputDirectory() {
        return this.compilation.getOutputDir();
    }

    @NotNull
    public final List<File> getJsFiles() {
        return this.jsFiles;
    }
}

