/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.netcat;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.IoHandlerAdapter;
import org.apache.mina.io.IoSession;

public class NetCatProtocolHandler
extends IoHandlerAdapter {
    public void sessionOpened(IoSession session) {
        session.getConfig().setIdleTime(IdleStatus.READER_IDLE, 10);
    }

    public void sessionClosed(IoSession session) {
        System.err.println("Total " + session.getReadBytes() + " byte(s)");
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (status == IdleStatus.READER_IDLE) {
            session.close();
        }
    }

    public void dataRead(IoSession session, ByteBuffer buf) {
        while (buf.hasRemaining()) {
            System.out.print((char)buf.get());
        }
        System.out.flush();
    }
}

