/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.protocol.ProtocolEncoderOutput;
import org.apache.mina.util.Queue;

public class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue bufferQueue = new Queue();

    public Queue getBufferQueue() {
        return this.bufferQueue;
    }

    public void write(ByteBuffer buf) {
        this.bufferQueue.push(buf);
    }

    public void mergeAll() {
        ByteBuffer buf;
        int sum = 0;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            sum += ((ByteBuffer)this.bufferQueue.get(i)).remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while ((buf = (ByteBuffer)this.bufferQueue.pop()) != null) {
            newBuf.put(buf);
            buf.release();
        }
        newBuf.flip();
        this.bufferQueue.push(newBuf);
    }
}

