/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.io;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.io.IoConnector;
import org.apache.mina.io.IoSession;
import org.apache.mina.protocol.ProtocolConnector;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.io.IoAdapter;
import org.apache.mina.protocol.io.IoProtocolSessionManagerFilterChain;

public class IoProtocolConnector
implements ProtocolConnector {
    private final IoConnector connector;
    private final IoAdapter adapter = new IoAdapter(new IoProtocolSessionManagerFilterChain(this));

    public IoProtocolConnector(IoConnector connector) {
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        this.connector = connector;
    }

    public IoConnector getIoConnector() {
        return this.connector;
    }

    public ProtocolSession connect(SocketAddress address, ProtocolProvider provider) throws IOException {
        IoSession session = this.connector.connect(address, this.adapter.adapt(provider));
        return this.adapter.toProtocolSession(session);
    }

    public ProtocolSession connect(SocketAddress address, SocketAddress localAddress, ProtocolProvider provider) throws IOException {
        IoSession session = this.connector.connect(address, localAddress, this.adapter.adapt(provider));
        return this.adapter.toProtocolSession(session);
    }

    public ProtocolSession connect(SocketAddress address, int timeout, ProtocolProvider provider) throws IOException {
        IoSession session = this.connector.connect(address, timeout, this.adapter.adapt(provider));
        return this.adapter.toProtocolSession(session);
    }

    public ProtocolSession connect(SocketAddress address, SocketAddress localAddress, int timeout, ProtocolProvider provider) throws IOException {
        IoSession session = this.connector.connect(address, localAddress, timeout, this.adapter.adapt(provider));
        return this.adapter.toProtocolSession(session);
    }

    public ProtocolFilterChain getFilterChain() {
        return this.adapter.getFilterChain();
    }

    public ExceptionMonitor getExceptionMonitor() {
        return this.connector.getExceptionMonitor();
    }

    public void setExceptionMonitor(ExceptionMonitor monitor) {
        this.connector.setExceptionMonitor(monitor);
    }
}

