/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.common.Session;
import org.apache.mina.io.IoSession;
import org.apache.mina.protocol.ProtocolSession;

public class SessionLog {
    public static final String PREFIX = SessionLog.class.getName() + ".prefix";
    public static final String LOGGER = SessionLog.class.getName() + ".logger";

    public static Logger getLogger(Session session) {
        Logger log = (Logger)session.getAttribute(LOGGER);
        if (log == null) {
            log = Logger.getLogger(SessionLog.getClassName(session));
            String prefix = (String)session.getAttribute(PREFIX);
            if (prefix == null) {
                prefix = "[" + session.getRemoteAddress() + "] ";
                session.setAttribute(PREFIX, prefix);
            }
            session.setAttribute(LOGGER, log);
        }
        return log;
    }

    private static String getClassName(Session session) {
        if (session instanceof IoSession) {
            return ((IoSession)session).getHandler().getClass().getName();
        }
        return ((ProtocolSession)session).getHandler().getClass().getName();
    }

    public static void log(Level level, Session session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isLoggable(level)) {
            log.log(level, message);
        }
    }

    public static void log(Level level, Session session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isLoggable(level)) {
            log.log(level, message, cause);
        }
    }
}

