/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.ArrayNamingEnumeration;
import org.apache.ldap.common.message.IteratorNamingEnumeration;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributes;
import org.apache.ldap.common.util.ExceptionUtils;

public class LockableAttributesImpl
extends AbstractLockable
implements LockableAttributes {
    private final Map map = new HashMap();
    private Map keyMap = new HashMap();

    public LockableAttributesImpl() {
        super(false);
    }

    public LockableAttributesImpl(Lockable parent) {
        super(parent, false);
    }

    private LockableAttributesImpl(Lockable parent, Map map, Map keyMap) {
        super(parent, false);
        if (keyMap != null) {
            this.keyMap.putAll(keyMap);
        }
        Iterator list = map.values().iterator();
        while (list.hasNext()) {
            Attribute attr = (Attribute)list.next();
            this.map.put(attr.getID(), attr.clone());
        }
    }

    public boolean isCaseIgnored() {
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public Attribute get(String attrId) {
        String l_key = this.getUserProvidedId(attrId);
        if (l_key == null) {
            return null;
        }
        return (Attribute)this.map.get(l_key);
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(this.map.values().iterator());
    }

    public NamingEnumeration getIDs() {
        return new ArrayNamingEnumeration(this.map.keySet().toArray());
    }

    public Attribute put(String attrId, Object val) {
        super.lockCheck("Attempt to add value to locked Attributes");
        Attribute l_attr = this.get(attrId);
        if (l_attr == null) {
            l_attr = new LockableAttributeImpl((Lockable)this, attrId);
            this.setUserProvidedId(attrId);
        }
        l_attr.add(val);
        this.map.put(attrId, l_attr);
        return l_attr;
    }

    public Attribute put(Attribute attr) {
        super.lockCheck("Attempt to Attribute to locked Attributes");
        Attribute l_old = this.get(attr.getID());
        if (l_old != null) {
            this.map.remove(l_old.getID());
            if (this.keyMap != null) {
                this.keyMap.remove(l_old.getID().toLowerCase());
            }
        }
        this.map.put(attr.getID(), attr);
        this.setUserProvidedId(attr.getID());
        return l_old;
    }

    public Attribute remove(String attrId) {
        super.lockCheck("Attempt to remove Attribute from locked Attributes");
        Attribute l_old = this.get(attrId);
        if (l_old != null) {
            this.map.remove(l_old.getID());
            if (this.keyMap != null) {
                this.keyMap.remove(l_old.getID().toLowerCase());
            }
        }
        return l_old;
    }

    public Object clone() {
        return new LockableAttributesImpl(this.getParent(), this.map, this.keyMap);
    }

    public String toString() {
        StringBuffer l_buf = new StringBuffer();
        Iterator l_attrs = this.map.values().iterator();
        while (l_attrs.hasNext()) {
            Attribute l_attr = (Attribute)l_attrs.next();
            try {
                NamingEnumeration<?> l_values = l_attr.getAll();
                while (l_values.hasMore()) {
                    Object l_value = l_values.next();
                    l_buf.append(l_attr.getID());
                    l_buf.append(": ");
                    l_buf.append(l_value);
                    l_buf.append('\n');
                }
            }
            catch (NamingException e) {
                l_buf.append(ExceptionUtils.getFullStackTrace(e));
            }
        }
        return l_buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes attrs = (Attributes)obj;
        if (attrs.size() != this.size()) {
            return false;
        }
        if (attrs.isCaseIgnored() != this.isCaseIgnored()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> list = attrs.getAll();
        while (list.hasMoreElements()) {
            Attribute attr = (Attribute)list.nextElement();
            Attribute myAttr = this.get(attr.getID());
            if (myAttr == null) {
                return false;
            }
            if (myAttr.equals(attr)) continue;
            return false;
        }
        return true;
    }

    private void setUserProvidedId(String userProvidedId) {
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
            this.keyMap.put(userProvidedId.toLowerCase(), userProvidedId);
            return;
        }
        if (this.keyMap.get(userProvidedId) == null) {
            this.keyMap.put(userProvidedId.toLowerCase(), userProvidedId);
        }
    }

    private String getUserProvidedId(String attrId) {
        if (this.map.containsKey(attrId)) {
            return attrId;
        }
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
            return null;
        }
        return (String)this.keyMap.get(attrId.toLowerCase());
    }
}

