/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.directory.ModificationItem;
import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ModifyRequest;

public class ModifyRequestImpl
extends AbstractRequest
implements ModifyRequest {
    private String name;
    private ArrayList mods = new ArrayList();

    public ModifyRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public Collection getModificationItems() {
        return Collections.unmodifiableCollection(this.mods);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.lockCheck("Attempt to alter object name of locked ModifyRequest!");
        this.name = name;
    }

    public void addModification(ModificationItem mod) {
        this.lockCheck("Attempt to add modification to locked ModifyRequest!");
        this.mods.add(mod);
    }

    public void removeModification(ModificationItem mod) {
        this.lockCheck("Attempt to remove modification to locked ModifyRequest!");
        this.mods.remove(mod);
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyRequest req = (ModifyRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (req.getModificationItems().size() != this.mods.size()) {
            return false;
        }
        Iterator list = req.getModificationItems().iterator();
        for (int ii = 0; ii < this.mods.size(); ++ii) {
            ModificationItem item = (ModificationItem)list.next();
            if (this.equals((ModificationItem)this.mods.get(ii), item)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ModificationItem item0, ModificationItem item1) {
        if (item0 == item1) {
            return true;
        }
        if (item0.getModificationOp() != item1.getModificationOp()) {
            return false;
        }
        return item0.getAttribute().getID().equals(item1.getAttribute().getID());
    }
}

