/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.schema;

import javax.naming.NamingException;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.common.util.LRUMap;

public class CachingNormalizer
implements Normalizer {
    public static final int CACHE_MAX = 250;
    private final LRUMap cache;
    private final Normalizer normalizer;

    public CachingNormalizer(Normalizer normalizer) {
        this(normalizer, 250);
    }

    public CachingNormalizer(Normalizer normalizer, int cacheSz) {
        this.normalizer = normalizer;
        this.cache = new LRUMap(cacheSz);
    }

    public Object normalize(Object value) throws NamingException {
        if (this.cache.containsKey(value)) {
            return this.cache.get(value);
        }
        Object normalized = this.normalizer.normalize(value);
        this.cache.put(value, normalized);
        return normalized;
    }
}

