/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.ldap.common.schema.AbstractSchemaObject;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.ObjectClass;
import org.apache.ldap.common.schema.ObjectClassTypeEnum;

public class DefaultObjectClass
extends AbstractSchemaObject
implements ObjectClass,
Serializable {
    private static final ObjectClass[] EMPTY_OCLASS_ARR = new ObjectClass[0];
    private static final AttributeType[] EMPTY_ATYPE_ARR = new AttributeType[0];
    private ObjectClassTypeEnum type = ObjectClassTypeEnum.ABSTRACT;
    private ArrayList mayList;
    private ArrayList mustList;
    private ArrayList superClasses;

    DefaultObjectClass(String oid) {
        super(oid);
    }

    public ObjectClass[] getSuperClasses() {
        if (this.superClasses == null) {
            return EMPTY_OCLASS_ARR;
        }
        return this.superClasses.toArray(EMPTY_OCLASS_ARR);
    }

    public ObjectClassTypeEnum getType() {
        return this.type;
    }

    public AttributeType[] getMustList() {
        if (this.mustList == null) {
            return EMPTY_ATYPE_ARR;
        }
        return this.mustList.toArray(EMPTY_ATYPE_ARR);
    }

    public AttributeType[] getMayList() {
        if (this.mayList == null) {
            return EMPTY_ATYPE_ARR;
        }
        return this.mayList.toArray(EMPTY_ATYPE_ARR);
    }

    void addToMayList(List mayList) {
        if (this.mayList == null) {
            this.mayList = new ArrayList();
        }
        this.mayList.addAll(mayList);
    }

    void addToMustList(List mustList) {
        if (this.mustList == null) {
            this.mustList = new ArrayList();
        }
        this.mustList.addAll(mustList);
    }

    void addSuperClasses(List superClasses) {
        if (this.superClasses == null) {
            this.superClasses = new ArrayList();
        }
        this.superClasses.addAll(superClasses);
    }

    void setType(ObjectClassTypeEnum type) {
        this.type = type;
    }
}

