/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class JoinIterator
implements Iterator {
    private final Iterator[] iterators;
    private int index;

    public JoinIterator(Iterator[] iterators) {
        if (iterators == null || iterators.length < 2) {
            throw new IllegalArgumentException("Iterator[] arg must not be null, empty or composed of less than two Iterators");
        }
        this.iterators = iterators;
        this.index = 0;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public Object next() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return this.iterators[this.index].next();
            }
            ++this.index;
        }
        throw new NoSuchElementException();
    }
}

