/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Stack;
import junit.framework.TestCase;
import org.apache.asn1.ber.BERDecoder;
import org.apache.asn1.ber.BERDecoderCallback;
import org.apache.asn1.ber.BERDecoderState;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.binary.BinaryCodec;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class AbstractDecoderTestCase
extends TestCase
implements BERDecoderCallback,
DecoderMonitor {
    protected ArrayList tlvList = new ArrayList();
    protected BERDecoder decoder = null;
    ByteBuffer buf = ByteBuffer.allocate(11111);

    protected void setUp() throws Exception {
        super.setUp();
        this.decoder = new BERDecoder();
        this.decoder.setCallback(this);
        this.decoder.setDecoderMonitor(this);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tlvList.clear();
        this.decoder = null;
    }

    public AbstractDecoderTestCase(String arg0) {
        super(arg0);
    }

    public byte[][] fragment(byte[] bites, int size) {
        Object fragments = null;
        if (size <= 0) {
            throw new IllegalArgumentException("fragment size should be 1 or more but was " + size);
        }
        int wholeFrags = bites.length / size;
        int partialFragSize = bites.length % size;
        if (partialFragSize == 0) {
            fragments = new byte[wholeFrags][];
        } else {
            fragments = new byte[wholeFrags + 1][];
            fragments[wholeFrags] = new byte[partialFragSize];
        }
        for (int ii = 0; ii < wholeFrags; ++ii) {
            fragments[ii] = new byte[size];
            System.arraycopy(bites, ii * size, fragments[ii], 0, size);
        }
        if (partialFragSize != 0) {
            int srcPos = wholeFrags * size;
            byte[] src = fragments[wholeFrags];
            System.arraycopy(bites, srcPos, src, 0, partialFragSize);
        }
        return fragments;
    }

    public ByteBuffer[] fragment(ByteBuffer bites, int size) {
        bites = bites.duplicate();
        ByteBuffer[] fragments = null;
        if (size <= 0) {
            throw new IllegalArgumentException("fragment size should be 1 or more but was " + size);
        }
        int wholeFrags = bites.remaining() / size;
        int partialFragSize = bites.remaining() % size;
        if (partialFragSize == 0) {
            fragments = new ByteBuffer[wholeFrags];
        } else {
            fragments = new ByteBuffer[wholeFrags + 1];
            fragments[wholeFrags] = ByteBuffer.allocate(partialFragSize);
        }
        for (int ii = 0; ii < wholeFrags; ++ii) {
            fragments[ii] = (ByteBuffer)bites.slice().limit(size);
            bites.position(bites.position() + size);
        }
        if (partialFragSize != 0) {
            fragments[wholeFrags].put(bites);
            fragments[wholeFrags].flip();
        }
        return fragments;
    }

    public Tuple decode(String bitString) throws DecoderException {
        byte[] bites = BinaryCodec.fromAscii(bitString.getBytes());
        ByteBuffer buf = ByteBuffer.wrap(bites);
        int lastSize = this.tlvList.size();
        this.decoder.decode(buf);
        if (this.tlvList.isEmpty() || this.tlvList.size() == lastSize) {
            return this.decoder.getCurrentTuple();
        }
        return (Tuple)this.tlvList.get(this.tlvList.size() - 1);
    }

    public Tuple decode(byte bite) throws DecoderException {
        byte[] bites = new byte[]{bite};
        ByteBuffer buf = ByteBuffer.wrap(bites);
        int lastSize = this.tlvList.size();
        this.decoder.decode(buf);
        if (this.tlvList.isEmpty() || this.tlvList.size() == lastSize) {
            return this.decoder.getCurrentTuple();
        }
        return (Tuple)this.tlvList.get(this.tlvList.size() - 1);
    }

    public Tuple decode(ByteBuffer bites) throws DecoderException {
        int lastSize = this.tlvList.size();
        this.decoder.decode(bites);
        if (this.tlvList.isEmpty() || this.tlvList.size() == lastSize) {
            return this.decoder.getCurrentTuple();
        }
        return (Tuple)this.tlvList.get(this.tlvList.size() - 1);
    }

    public Tuple decode(Tuple tlv, ByteBuffer value) throws DecoderException {
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
        list.add(value);
        ByteBuffer buf = tlv.toEncodedBuffer(list);
        int lastSize = this.tlvList.size();
        this.decoder.decode(buf);
        if (this.tlvList.isEmpty() || this.tlvList.size() == lastSize) {
            Stack stack = this.decoder.getTupleStack();
            if (stack.isEmpty()) {
                return this.decoder.getCurrentTuple();
            }
            return (Tuple)stack.peek();
        }
        return (Tuple)this.tlvList.get(this.tlvList.size() - 1);
    }

    public Tuple decode(Tuple[] tlvs, ByteBuffer[] values) throws DecoderException {
        int lastSize = this.tlvList.size();
        for (int ii = 0; ii < tlvs.length; ++ii) {
            this.decode(tlvs[ii], values[ii]);
        }
        if (this.tlvList.isEmpty() || this.tlvList.size() == lastSize) {
            return this.decoder.getCurrentTuple();
        }
        return (Tuple)this.tlvList.get(this.tlvList.size() - 1);
    }

    public Tuple decode(byte[] pdu) throws DecoderException {
        this.decode(ByteBuffer.wrap(pdu));
        return (Tuple)this.tlvList.get(this.tlvList.size() - 1);
    }

    public void tagDecoded(Tuple tlv) {
        AbstractDecoderTestCase.assertTrue((boolean)this.decoder.getCurrentTuple().equals(tlv));
        AbstractDecoderTestCase.assertEquals((Object)BERDecoderState.TAG, (Object)this.decoder.getState());
    }

    public void lengthDecoded(Tuple tlv) {
        AbstractDecoderTestCase.assertTrue((boolean)this.decoder.getCurrentTuple().equals(tlv));
        AbstractDecoderTestCase.assertEquals((Object)BERDecoderState.LENGTH, (Object)this.decoder.getState());
        this.buf.clear();
    }

    public void partialValueDecoded(Tuple tlv) {
        this.buf.put(tlv.valueChunk);
    }

    public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
        Tuple t = (Tuple)decoded;
        this.tlvList.add(t.clone());
        AbstractDecoderTestCase.assertEquals((Object)BERDecoderState.VALUE, (Object)this.decoder.getState());
        this.buf.flip();
    }

    public void callbackOccured(StatefulDecoder decoder, DecoderCallback cb, Object decoded) {
        AbstractDecoderTestCase.assertEquals((Object)this, (Object)cb);
        AbstractDecoderTestCase.assertEquals((Object)this.decoder, (Object)decoder);
        Tuple t = (Tuple)decoded;
        AbstractDecoderTestCase.assertNotNull((Object)t);
        if (t.isPrimitive) {
            AbstractDecoderTestCase.assertTrue((boolean)this.decoder.getCurrentTuple().equals(decoded));
        }
    }

    public void callbackSet(StatefulDecoder decoder, DecoderCallback oldcb, DecoderCallback newcb) {
        AbstractDecoderTestCase.assertEquals((Object)this, (Object)newcb);
    }

    public void error(StatefulDecoder decoder, Exception exception) {
        AbstractDecoderTestCase.fail((String)ExceptionUtils.getFullStackTrace(exception));
    }

    public void fatalError(StatefulDecoder decoder, Exception exception) {
        AbstractDecoderTestCase.fail((String)ExceptionUtils.getFullStackTrace(exception));
    }

    public void monitorSet(StatefulDecoder decoder, DecoderMonitor oldmon) {
        AbstractDecoderTestCase.assertEquals((Object)this, (Object)oldmon);
    }

    public void warning(StatefulDecoder decoder, Exception exception) {
        AbstractDecoderTestCase.assertNotNull((Object)exception);
    }
}

