/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.TupleNodeVisitor;
import org.apache.asn1.ber.VisitorMonitor;

public class DeterminateLengthVisitor
implements TupleNodeVisitor {
    private VisitorMonitor monitor = VisitorMonitor.NOOP;

    public void visit(TupleNode node) {
        int length = 0;
        Iterator children = node.getChildren();
        while (children.hasNext()) {
            TupleNode childTuple = (TupleNode)children.next();
            Tuple tlv = childTuple.getTuple();
            if (tlv.isIndefiniteTerminator()) {
                ((MutableTupleNode)childTuple).setParent(null);
                continue;
            }
            length += tlv.size();
        }
        node.getTuple().setValueLength(length);
        this.monitor.visited(this, node);
    }

    public boolean canVisit(TupleNode node) {
        return node.getTuple().isIndefinite();
    }

    public boolean isPrefix() {
        return false;
    }

    public ArrayList getOrder(TupleNode node, ArrayList children) {
        return children;
    }

    public void setMonitor(VisitorMonitor monitor) {
        this.monitor = monitor;
    }
}

