/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.asn1.ber.BERDecoder;
import org.apache.asn1.ber.BERDecoderCallback;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.CallbackHistory;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1.codec.stateful.DecoderMonitorAdapter;
import org.apache.asn1.codec.stateful.StatefulDecoder;

public class TupleTreeDecoder
implements StatefulDecoder {
    Stack stack = new Stack();
    BERDecoder decoder = new BERDecoder();
    DecoderCallback cb = null;
    DecoderMonitor monitor = new DecoderMonitorAdapter();
    ArrayList valueChunks = new ArrayList();

    public TupleTreeDecoder() {
        BERDecoderCallback berCallback = new BERDecoderCallback(){

            public void tagDecoded(Tuple tlv) {
            }

            public void partialValueDecoded(Tuple tlv) {
                ByteBuffer copy = ByteBuffer.allocate(tlv.getLastValueChunk().remaining());
                copy.put(tlv.getLastValueChunk());
                tlv.getLastValueChunk().rewind();
                copy.rewind();
                TupleTreeDecoder.this.valueChunks.add(copy);
            }

            public void lengthDecoded(Tuple tlv) {
                if (!tlv.isPrimitive) {
                    DefaultMutableTupleNode child = null;
                    DefaultMutableTupleNode parent = null;
                    Tuple cloned = (Tuple)tlv.clone();
                    if (TupleTreeDecoder.this.stack.isEmpty()) {
                        TupleTreeDecoder.this.stack.push(new DefaultMutableTupleNode(cloned));
                        return;
                    }
                    parent = (DefaultMutableTupleNode)TupleTreeDecoder.this.stack.peek();
                    child = new DefaultMutableTupleNode(cloned);
                    child.setParent(parent);
                    parent.addLast(child);
                    TupleTreeDecoder.this.stack.push(child);
                }
            }

            public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
                TupleTreeDecoder.this.handleTuple((Tuple)decoded);
            }
        };
        this.decoder.setCallback(berCallback);
        this.decoder.setDecoderMonitor(this.monitor);
    }

    private void handleTuple(Tuple t) {
        DefaultMutableTupleNode node = null;
        DefaultMutableTupleNode parent = null;
        if (t.isPrimitive) {
            node = new DefaultMutableTupleNode((Tuple)t.clone(), this.valueChunks);
            this.valueChunks.clear();
            if (!this.stack.isEmpty()) {
                parent = (DefaultMutableTupleNode)this.stack.peek();
                node.setParent(parent);
                parent.addLast(node);
            }
            return;
        }
        node = (DefaultMutableTupleNode)this.stack.pop();
        if (this.cb != null && this.stack.isEmpty()) {
            this.cb.decodeOccurred(this, node);
        }
    }

    public void decode(Object encoded) throws DecoderException {
        this.decoder.decode(encoded);
    }

    public static TupleNode treeDecode(ByteBuffer buf) throws DecoderException {
        TupleTreeDecoder decoder = new TupleTreeDecoder();
        CallbackHistory history = new CallbackHistory(1);
        decoder.setCallback(history);
        decoder.decode(buf);
        if (history.isEmpty()) {
            return null;
        }
        return (TupleNode)history.getMostRecent();
    }

    public void setCallback(DecoderCallback cb) {
        this.cb = cb;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.monitor = monitor;
        this.decoder.setDecoderMonitor(monitor);
    }
}

