/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester.rules;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.asn1.ber.digester.rules.ByteAccumulator;
import org.apache.asn1.ber.primitives.UniversalTag;

public class PrimitiveOctetStringRule
extends AbstractRule {
    private final ByteAccumulator accumulator = new ByteAccumulator(0);
    private boolean isConstructed = false;
    private final TagEnum tag;

    public PrimitiveOctetStringRule() {
        this.tag = UniversalTag.OCTET_STRING;
    }

    public PrimitiveOctetStringRule(TagEnum tag) {
        this.tag = tag;
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        boolean bl = this.isConstructed = !isPrimitive;
        if (this.isConstructed) {
            return;
        }
        if (this.tag.getTagId() != id) {
            throw new IllegalArgumentException("Expecting " + this.tag.getName() + " with an id of " + this.tag.getTagId() + " but instead got a tag id of " + id);
        }
    }

    public void length(int length) {
        if (this.isConstructed) {
            return;
        }
        if (-2 != length) {
            this.accumulator.ensureCapacity(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isConstructed) {
            return;
        }
        if (buf == null || !buf.hasRemaining()) {
            return;
        }
        this.accumulator.fill(buf);
    }

    public void finish() {
        if (this.isConstructed) {
            return;
        }
        this.getDigester().push(this.accumulator.drain(0));
        this.isConstructed = false;
    }

    protected ByteAccumulator getAccumulator() {
        return this.accumulator;
    }

    protected boolean isConstructed() {
        return this.isConstructed;
    }

    protected void setConstructed(boolean isConstructed) {
        this.isConstructed = isConstructed;
    }

    protected TagEnum getTag() {
        return this.tag;
    }
}

