/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.codec.stateful;

import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1.codec.stateful.StatefulDecoder;

public abstract class AbstractStatefulDecoder
implements StatefulDecoder {
    private DecoderCallback cb = null;
    private DecoderMonitor monitor = null;

    public AbstractStatefulDecoder() {
    }

    public AbstractStatefulDecoder(DecoderCallback cb) {
        this.setCallback(cb);
    }

    public AbstractStatefulDecoder(DecoderMonitor monitor) {
        this.monitor = monitor;
    }

    public AbstractStatefulDecoder(DecoderCallback cb, DecoderMonitor monitor) {
        this.monitor = monitor;
        this.setCallback(cb);
    }

    public void setCallback(DecoderCallback cb) {
        DecoderCallback old = this.cb;
        this.cb = cb;
        if (this.monitor != null) {
            this.monitor.callbackSet(this, old, cb);
        }
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.monitor = monitor;
    }

    protected void decodeOccurred(Object decoded) {
        if (this.cb != null) {
            this.cb.decodeOccurred(this, decoded);
        }
    }

    protected DecoderMonitor getDecoderMonitor() {
        return this.monitor;
    }
}

