/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.codec.stateful.examples;

import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.EncoderMonitor;
import org.apache.asn1.codec.stateful.EncoderMonitorAdapter;
import org.apache.asn1.codec.stateful.StatefulEncoder;

public class HexEncoder
implements StatefulEncoder {
    private static final int CHUNK_SZ = 128;
    private ByteBuffer buf = ByteBuffer.allocate(128);
    private EncoderMonitor monitor = new EncoderMonitorAdapter();
    private EncoderCallback cb = new EncoderCallback(){

        public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
        }
    };
    private final byte[] HEXCHAR_LUT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public void encode(Object obj) throws EncoderException {
        ByteBuffer raw = (ByteBuffer)obj;
        if (raw == null || !raw.hasRemaining()) {
            return;
        }
        while (raw.hasRemaining()) {
            if (!this.buf.hasRemaining()) {
                this.buf.flip();
                this.cb.encodeOccurred(this, this.buf);
                this.monitor.callbackOccured(this, this.cb, this.buf);
                this.buf.clear();
            }
            byte bite = raw.get();
            this.buf.put(this.HEXCHAR_LUT[bite >> 4 & 0xF]);
            this.buf.put(this.HEXCHAR_LUT[bite & 0xF]);
        }
        this.buf.flip();
        this.cb.encodeOccurred(this, this.buf);
        this.monitor.callbackOccured(this, this.cb, this.buf);
        this.buf.clear();
    }

    public void setCallback(EncoderCallback cb) {
        EncoderCallback old = this.cb;
        this.cb = cb;
        this.monitor.callbackSet(this, old, cb);
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
        this.monitor = monitor;
    }
}

