/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.RandomAccessIntList;

public class ArrayUnsignedShortList
extends RandomAccessIntList
implements IntList,
Serializable {
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    private transient short[] _data = null;
    private int _size = 0;

    public ArrayUnsignedShortList() {
        this(8);
    }

    public ArrayUnsignedShortList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new short[initialCapacity];
        this._size = 0;
    }

    public ArrayUnsignedShortList(IntCollection that) {
        this(that.size());
        this.addAll(that);
    }

    public int get(int index) {
        this.checkRange(index);
        return this.toInt(this._data[index]);
    }

    public int size() {
        return this._size;
    }

    public int removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        int oldval = this.toInt(this._data[index]);
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public int set(int index, int element) {
        this.assertValidUnsignedShort(element);
        this.checkRange(index);
        this.incrModCount();
        int oldval = this.toInt(this._data[index]);
        this._data[index] = this.fromInt(element);
        return oldval;
    }

    public void add(int index, int element) {
        this.assertValidUnsignedShort(element);
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = this.fromInt(element);
        ++this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            short[] olddata = this._data;
            this._data = new short[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            short[] olddata = this._data;
            this._data = new short[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private final int toInt(short value) {
        return value & 0xFFFF;
    }

    private final short fromInt(int value) {
        return (short)(value & 0xFFFF);
    }

    private final void assertValidUnsignedShort(int value) throws IllegalArgumentException {
        if (value > 65535) {
            throw new IllegalArgumentException(value + " > " + 65535);
        }
        if (value < 0) {
            throw new IllegalArgumentException(value + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeShort(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new short[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readShort();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

