/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.crypto;

import java.security.SecureRandom;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.DesStringToKey;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.messages.value.EncryptionKey;

public class RandomKey {
    private static final SecureRandom random = new SecureRandom();

    public EncryptionKey getNewSessionKey() {
        byte[] confounder = RandomKey.getRandomBytes(8);
        DesStringToKey subSessionKey = new DesStringToKey(new String(confounder));
        return new EncryptionKey(EncryptionType.DES_CBC_MD5, subSessionKey.getKey());
    }

    public static KerberosKey getRandomKeyFor(KerberosPrincipal principal) {
        int DES_KEY_TYPE = 3;
        int keyVersion = 1;
        byte[] randomBytes = RandomKey.getRandomBytes(8);
        DesStringToKey randomKey = new DesStringToKey(new String(randomBytes));
        return new KerberosKey(principal, randomKey.getKey(), 3, keyVersion);
    }

    private static byte[] getRandomBytes(int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }
}

