/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.ASN1InputStream;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.messages.value.EncryptedData;
import org.apache.kerberos.messages.value.EncryptedDataModifier;

public class EncryptedDataDecoder {
    public static EncryptedData decode(byte[] encodedEncryptedData) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedEncryptedData);
        DERSequence sequence = (DERSequence)ais.readObject();
        return EncryptedDataDecoder.decode(sequence);
    }

    public static EncryptedData decode(DERSequence sequence) {
        EncryptedDataModifier modifier = new EncryptedDataModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger etype = (DERInteger)derObject;
                    modifier.setEncryptionType(EncryptionType.getTypeByOrdinal(etype.intValue()));
                    break;
                }
                case 1: {
                    DERInteger kvno = (DERInteger)derObject;
                    modifier.setKeyVersion(kvno.intValue());
                    break;
                }
                case 2: {
                    DEROctetString cipher = (DEROctetString)derObject;
                    modifier.setCipherText(cipher.getOctets());
                }
            }
        }
        return modifier.getEncryptedData();
    }
}

