/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.ASN1InputStream;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.messages.value.PreAuthenticationData;
import org.apache.kerberos.messages.value.PreAuthenticationDataModifier;
import org.apache.kerberos.messages.value.PreAuthenticationDataType;

public class PreAuthenticationDataDecoder {
    public PreAuthenticationData decode(byte[] encodedPreAuthData) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedPreAuthData);
        DERSequence sequence = (DERSequence)ais.readObject();
        return PreAuthenticationDataDecoder.decode(sequence);
    }

    protected static PreAuthenticationData[] decodeSequence(DERSequence sequence) {
        PreAuthenticationData[] paDataSequence = new PreAuthenticationData[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            PreAuthenticationData paData;
            DERSequence object = (DERSequence)e.nextElement();
            paDataSequence[ii] = paData = PreAuthenticationDataDecoder.decode(object);
            ++ii;
        }
        return paDataSequence;
    }

    protected static PreAuthenticationData decode(DERSequence sequence) {
        PreAuthenticationDataModifier modifier = new PreAuthenticationDataModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 1: {
                    DERInteger padataType = (DERInteger)derObject;
                    PreAuthenticationDataType type = PreAuthenticationDataType.getTypeByOrdinal(padataType.intValue());
                    modifier.setDataType(type);
                    break;
                }
                case 2: {
                    DEROctetString padataValue = (DEROctetString)derObject;
                    modifier.setDataValue(padataValue.getOctets());
                }
            }
        }
        return modifier.getPreAuthenticationData();
    }
}

