/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.util.Enumeration;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.messages.value.PrincipalName;
import org.apache.kerberos.messages.value.PrincipalNameModifier;

public class PrincipalNameDecoder {
    public static PrincipalName decode(DERSequence sequence) {
        PrincipalNameModifier modifier = new PrincipalNameModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger nameType = (DERInteger)derObject;
                    modifier.setType(nameType.intValue());
                    break;
                }
                case 1: {
                    DERSequence nameString = (DERSequence)derObject;
                    PrincipalNameDecoder.decodeNameString(nameString, modifier);
                }
            }
        }
        return modifier.getPrincipalName();
    }

    private static void decodeNameString(DERSequence sequence, PrincipalNameModifier modifier) {
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERGeneralString object = (DERGeneralString)e.nextElement();
            modifier.addName(object.getString());
        }
    }
}

