/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asn1.der.ASN1OutputStream;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.encoder.EncryptedDataEncoder;
import org.apache.kerberos.messages.application.ApplicationReply;

public class ApplicationReplyEncoder {
    public static final int APPLICATION_CODE = 15;

    public byte[] encode(ApplicationReply reply) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence replySequence = this.encodeReplySequence(reply);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)15, (DEREncodable)replySequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeReplySequence(ApplicationReply message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)message.getProtocolVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)message.getMessageType().getOrdinal())));
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)EncryptedDataEncoder.encodeSequence(message.getEncPart())));
        return sequence;
    }
}

