/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asn1.der.ASN1OutputStream;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.encoder.KerberosTimeEncoder;
import org.apache.kerberos.messages.value.EncryptedTimeStamp;

public class EncryptedTimestampEncoder {
    public byte[] encode(EncryptedTimeStamp encryptedTimestamp) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)this.encodeTimestamp(encryptedTimestamp));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeTimestamp(EncryptedTimeStamp encryptedTimestamp) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)KerberosTimeEncoder.encode(encryptedTimestamp.getTimeStamp())));
        if (encryptedTimestamp.getMicroSeconds() > 0) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)encryptedTimestamp.getMicroSeconds())));
        }
        return sequence;
    }
}

