/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.asn1.der.ASN1OutputStream;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.encoder.KerberosTimeEncoder;
import org.apache.kerberos.io.encoder.PrincipalNameEncoder;
import org.apache.kerberos.messages.ErrorMessage;

public class ErrorMessageEncoder {
    public void encode(ErrorMessage message, ByteBuffer out) throws IOException {
        ASN1OutputStream aos = new ASN1OutputStream(out);
        DERSequence errorReply = this.encodeErrorMessageSequence(message);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)message.getMessageType().getOrdinal(), (DEREncodable)errorReply));
        aos.close();
    }

    public byte[] encode(ErrorMessage message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence errorReply = this.encodeErrorMessageSequence(message);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)message.getMessageType().getOrdinal(), (DEREncodable)errorReply));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeErrorMessageSequence(ErrorMessage message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)message.getProtocolVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)message.getMessageType().getOrdinal())));
        if (message.getClientTime() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)KerberosTimeEncoder.encode(message.getClientTime())));
        }
        if (message.getClientMicroSecond() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)DERInteger.valueOf((int)message.getClientMicroSecond())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)KerberosTimeEncoder.encode(message.getServerTime())));
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)DERInteger.valueOf((int)message.getServerMicroSecond())));
        sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)DERInteger.valueOf((int)message.getErrorCode())));
        if (message.getClientPrincipal() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(7, (DEREncodable)DERGeneralString.valueOf((String)message.getClientPrincipal().getRealm().toString())));
        }
        if (message.getClientPrincipal() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(8, (DEREncodable)PrincipalNameEncoder.encode(message.getClientPrincipal())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(9, (DEREncodable)DERGeneralString.valueOf((String)message.getServerPrincipal().getRealm())));
        sequence.add((DEREncodable)new DERTaggedObject(10, (DEREncodable)PrincipalNameEncoder.encode(message.getServerPrincipal())));
        if (message.getExplanatoryText() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(11, (DEREncodable)DERGeneralString.valueOf((String)message.getExplanatoryText())));
        }
        if (message.getExplanatoryData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(12, (DEREncodable)new DEROctetString(message.getExplanatoryData())));
        }
        return sequence;
    }
}

