/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.messages.KerberosMessage;
import org.apache.kerberos.messages.MessageType;
import org.apache.kerberos.messages.components.EncKdcRepPart;
import org.apache.kerberos.messages.components.Ticket;
import org.apache.kerberos.messages.value.EncryptedData;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.HostAddresses;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.LastRequest;
import org.apache.kerberos.messages.value.PreAuthenticationData;
import org.apache.kerberos.messages.value.TicketFlags;

public class KdcReply
extends KerberosMessage {
    private PreAuthenticationData[] _paData;
    private KerberosPrincipal _clientPrincipal;
    private Ticket _ticket;
    private EncKdcRepPart _encKDCRepPart = new EncKdcRepPart();
    private EncryptedData _encPart;

    public KdcReply(MessageType msgType) {
        super(msgType);
    }

    public KdcReply(PreAuthenticationData[] paData, KerberosPrincipal clientPrincipal, Ticket ticket, EncryptedData encPart, MessageType msgType) {
        this(msgType);
        this._paData = paData;
        this._clientPrincipal = clientPrincipal;
        this._ticket = ticket;
        this._encPart = encPart;
    }

    public KerberosPrincipal getClientPrincipal() {
        return this._clientPrincipal;
    }

    public String getClientRealm() {
        return this._clientPrincipal.getRealm();
    }

    public EncryptedData getEncPart() {
        return this._encPart;
    }

    public PreAuthenticationData[] getPaData() {
        return this._paData;
    }

    public Ticket getTicket() {
        return this._ticket;
    }

    public void setClientPrincipal(KerberosPrincipal clientPrincipal) {
        this._clientPrincipal = clientPrincipal;
    }

    public void setEncKDCRepPart(EncKdcRepPart repPart) {
        this._encKDCRepPart = repPart;
    }

    public void setEncPart(EncryptedData part) {
        this._encPart = part;
    }

    public void setPaData(PreAuthenticationData[] data) {
        this._paData = data;
    }

    public void setTicket(Ticket ticket) {
        this._ticket = ticket;
    }

    public KerberosTime getAuthTime() {
        return this._encKDCRepPart.getAuthTime();
    }

    public HostAddresses getClientAddresses() {
        return this._encKDCRepPart.getClientAddresses();
    }

    public KerberosTime getEndTime() {
        return this._encKDCRepPart.getEndTime();
    }

    public TicketFlags getFlags() {
        return this._encKDCRepPart.getFlags();
    }

    public EncryptionKey getKey() {
        return this._encKDCRepPart.getKey();
    }

    public KerberosTime getKeyExpiration() {
        return this._encKDCRepPart.getKeyExpiration();
    }

    public LastRequest getLastRequest() {
        return this._encKDCRepPart.getLastRequest();
    }

    public int getNonce() {
        return this._encKDCRepPart.getNonce();
    }

    public KerberosTime getRenewTill() {
        return this._encKDCRepPart.getRenewTill();
    }

    public KerberosPrincipal getServerPrincipal() {
        return this._encKDCRepPart.getServerPrincipal();
    }

    public String getServerRealm() {
        return this._encKDCRepPart.getServerRealm();
    }

    public KerberosTime getStartTime() {
        return this._encKDCRepPart.getStartTime();
    }

    public void setAuthTime(KerberosTime time) {
        this._encKDCRepPart.setAuthTime(time);
    }

    public void setClientAddresses(HostAddresses addresses) {
        this._encKDCRepPart.setClientAddresses(addresses);
    }

    public void setEndTime(KerberosTime time) {
        this._encKDCRepPart.setEndTime(time);
    }

    public void setFlags(TicketFlags flags) {
        this._encKDCRepPart.setFlags(flags);
    }

    public void setKey(EncryptionKey key) {
        this._encKDCRepPart.setKey(key);
    }

    public void setKeyExpiration(KerberosTime expiration) {
        this._encKDCRepPart.setKeyExpiration(expiration);
    }

    public void setLastRequest(LastRequest request) {
        this._encKDCRepPart.setLastRequest(request);
    }

    public void setNonce(int nonce) {
        this._encKDCRepPart.setNonce(nonce);
    }

    public void setRenewTill(KerberosTime till) {
        this._encKDCRepPart.setRenewTill(till);
    }

    public void setServerPrincipal(KerberosPrincipal principal) {
        this._encKDCRepPart.setServerPrincipal(principal);
    }

    public void setStartTime(KerberosTime time) {
        this._encKDCRepPart.setStartTime(time);
    }
}

