/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class MessageType
implements Comparable {
    public static final MessageType NULL = new MessageType(0, "null");
    public static final MessageType KRB_AS_REQ = new MessageType(10, "initial authentication request");
    public static final MessageType KRB_AS_REP = new MessageType(11, "initial authentication response");
    public static final MessageType KRB_TGS_REQ = new MessageType(12, "request for authentication based on TGT");
    public static final MessageType KRB_TGS_REP = new MessageType(13, "response to authentication based on TGT");
    public static final MessageType KRB_AP_REQ = new MessageType(14, "application request");
    public static final MessageType KRB_AP_REP = new MessageType(15, "application response");
    public static final MessageType KRB_SAFE = new MessageType(20, "safe (checksummed) application message");
    public static final MessageType KRB_PRIV = new MessageType(21, "private (encrypted) application message");
    public static final MessageType KRB_CRED = new MessageType(22, "private (encrypted) message to forward credentials");
    public static final MessageType ENC_AP_REP_PART = new MessageType(27, "encrypted application reply part");
    public static final MessageType ENC_PRIV_PART = new MessageType(28, "encrypted private message part");
    public static final MessageType KRB_ERROR = new MessageType(30, "error response");
    private static final MessageType[] values = new MessageType[]{NULL, KRB_AS_REQ, KRB_AS_REP, KRB_TGS_REQ, KRB_TGS_REP, KRB_AP_REQ, KRB_AP_REP, KRB_SAFE, KRB_PRIV, KRB_CRED, ENC_AP_REP_PART, ENC_PRIV_PART, KRB_ERROR};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private MessageType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }

    public int compareTo(Object that) {
        return this.ordinal - ((MessageType)that).ordinal;
    }

    public static MessageType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (MessageType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

