/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.components;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MessageComponentType
implements Comparable {
    public static final MessageComponentType NULL = new MessageComponentType(0, "null");
    public static final MessageComponentType KRB_TKT = new MessageComponentType(1, "ticket");
    public static final MessageComponentType KRB_AUTHENTICATOR = new MessageComponentType(2, "authenticator");
    public static final MessageComponentType KRB_ENC_TKT_PART = new MessageComponentType(3, "encrypted ticket part");
    public static final MessageComponentType KRB_ENC_AS_REP_PART = new MessageComponentType(25, "encrypted initial authentication part");
    public static final MessageComponentType KRB_ENC_TGS_REP_PART = new MessageComponentType(26, "encrypted TGS request part");
    public static final MessageComponentType KRB_ENC_AP_REP_PART = new MessageComponentType(27, "encrypted application request part");
    public static final MessageComponentType KRB_ENC_KRB_PRIV_PART = new MessageComponentType(28, "encrypted application message part");
    public static final MessageComponentType KRB_ENC_KRB_CRED_PART = new MessageComponentType(29, "encrypted credentials forward part");
    private final String _fName;
    private final int _fOrdinal;
    private static final MessageComponentType[] fValues = new MessageComponentType[]{NULL, KRB_TKT, KRB_AUTHENTICATOR, KRB_ENC_TKT_PART, KRB_ENC_AS_REP_PART, KRB_ENC_TGS_REP_PART, KRB_ENC_AP_REP_PART, KRB_ENC_KRB_PRIV_PART, KRB_ENC_KRB_CRED_PART};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(fValues));

    public String toString() {
        return this._fName + " (" + this._fOrdinal + ")";
    }

    public int compareTo(Object that) {
        return this._fOrdinal - ((MessageComponentType)that)._fOrdinal;
    }

    public static MessageComponentType getTypeByOrdinal(int type) {
        for (int i = 0; i < fValues.length; ++i) {
            if (MessageComponentType.fValues[i]._fOrdinal != type) continue;
            return fValues[i];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this._fOrdinal;
    }

    private MessageComponentType(int ordinal, String name) {
        this._fOrdinal = ordinal;
        this._fName = name;
    }
}

