/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common;

import java.io.Serializable;
import org.apache.ldap.common.LockException;
import org.apache.ldap.common.Lockable;

public abstract class AbstractLockable
implements Lockable,
Serializable {
    private Lockable m_parent;
    private boolean m_isUnlockable = true;
    private boolean m_isLocked = false;

    public AbstractLockable() {
    }

    protected AbstractLockable(boolean a_isUnlockable) {
        this.m_isUnlockable = a_isUnlockable;
        this.m_parent = null;
    }

    protected AbstractLockable(Lockable a_parent, boolean a_isUnlockable) {
        this.m_isUnlockable = a_isUnlockable;
        this.m_parent = a_parent;
    }

    public boolean isUnlockable() {
        if (this.m_parent == null) {
            return this.m_isUnlockable;
        }
        return this.m_parent.isUnlockable();
    }

    public boolean isLocked() {
        if (this.m_parent == null) {
            return this.m_isLocked;
        }
        return this.m_parent.isLocked();
    }

    public boolean getLocked() {
        if (this.m_parent == null) {
            return this.m_isLocked;
        }
        return this.m_parent.isLocked();
    }

    public void setLocked(boolean a_isLocked) throws LockException {
        if (this.m_parent == null) {
            if (this.m_isLocked == a_isLocked) {
                return;
            }
            if (this.m_isUnlockable) {
                this.m_isLocked = a_isLocked;
            } else if (this.m_isLocked) {
                throw new LockException(this, "Cannot unlock a \"permanent\" Lockable!");
            }
            return;
        }
        throw new LockException(this, "Cannot [un]lock a non-root Lockable!");
    }

    public Lockable getParent() {
        return this.m_parent;
    }

    protected void lockCheck(String a_msg) {
        if (this.isLocked()) {
            throw new LockException(this, a_msg);
        }
    }

    protected void lockCheck() {
        if (this.isLocked()) {
            throw new LockException(this);
        }
    }
}

