/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder;

import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.ldap.common.berlib.asn1.LdapMessageFactory;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ResultResponse;

public abstract class ResultResponseRule
extends AbstractRule {
    private final LdapTag tag;

    protected ResultResponseRule(LdapTag tag) {
        this.tag = tag;
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        if (this.tag.getTagId() != id) {
            throw new IllegalStateException("Rule firing stage method " + this + ".tag() expected an id of " + this.tag.getTagId() + " for tag " + this.tag + " but instead encountered a tag id " + " of " + id);
        }
        super.tag(id, isPrimitive, typeClass);
        int messageId = this.getDigester().popInt();
        ResultResponse resp = (ResultResponse)LdapMessageFactory.create(id, messageId);
        resp.setLdapResult(new LdapResultImpl(resp));
        this.getDigester().push(resp);
    }

    public void finish() {
        if (this.getDigester().peek() instanceof ResultResponse) {
            this.getDigester().pop();
        }
    }
}

