/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.ldap.common.berlib.asn1.BufferUtils;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.ResultResponse;

public class ResultRule
extends AbstractRule {
    private LdapResult result = null;

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        super.tag(id, isPrimitive, typeClass);
        ResultResponse resp = (ResultResponse)this.getDigester().peek();
        this.result = new LdapResultImpl(resp);
        this.getDigester().push(this.result);
    }

    public void finish() {
        super.finish();
        ByteBuffer buf = (ByteBuffer)this.getDigester().pop();
        this.result.setErrorMessage(new String(BufferUtils.getArray(buf)));
        buf = (ByteBuffer)this.getDigester().pop();
        this.result.setMatchedDn(new String(BufferUtils.getArray(buf)));
        int resultCode = this.getDigester().popInt();
        this.result.setResultCode(ResultCodeEnum.getResultCodeEnum(resultCode));
        this.getDigester().pop();
    }
}

