/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.message.SearchResponseEntryImpl;

public class SearchResponseEntryAttributesRule
extends AbstractRule {
    private final TagEnum expected;

    public SearchResponseEntryAttributesRule(TagEnum expected) {
        this.expected = expected;
    }

    public SearchResponseEntryAttributesRule() {
        this.expected = UniversalTag.SEQUENCE_SEQUENCE_OF;
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        super.tag(id, isPrimitive, typeClass);
        if (id != this.expected.getTagId()) {
            throw new IllegalArgumentException("expected tag with id " + this.expected.getTagId() + " for " + this.expected + " but got " + id + "instead");
        }
        SearchResponseEntryImpl req = (SearchResponseEntryImpl)this.getDigester().peek();
        LockableAttributesImpl attrs = new LockableAttributesImpl(req);
        req.setAttributes(attrs);
        this.getDigester().push(attrs);
    }

    public void finish() {
        super.finish();
        this.getDigester().pop();
    }
}

