/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;

public class EncoderUtils {
    public static TupleNode encode(String octets) {
        return EncoderUtils.encode((TagEnum)UniversalTag.OCTET_STRING, octets);
    }

    public static TupleNode encode(TagEnum tag, String octets) {
        Tuple t = new Tuple();
        t.setTag(tag, true);
        ByteBuffer chunk = ByteBuffer.wrap(octets.getBytes());
        t.setLength(chunk.remaining());
        t.setLastValueChunk(chunk);
        return new DefaultMutableTupleNode(t);
    }

    public static TupleNode encode(byte[] octets) {
        return EncoderUtils.encode((TagEnum)UniversalTag.OCTET_STRING, octets);
    }

    public static TupleNode encode(TagEnum tag, byte[] octets) {
        Tuple t = new Tuple();
        t.setTag(tag, true);
        ByteBuffer chunk = ByteBuffer.wrap(octets);
        t.setLength(chunk.remaining());
        t.setLastValueChunk(chunk);
        return new DefaultMutableTupleNode(t);
    }

    public static TupleNode encode(int intval) {
        return EncoderUtils.encode((TagEnum)UniversalTag.INTEGER, intval);
    }

    public static TupleNode encode(TagEnum tag, int intval) {
        Tuple t = new Tuple();
        t.setTag(tag, true);
        ByteBuffer chunk = ByteBuffer.wrap(PrimitiveUtils.encodeInt(intval));
        t.setLength(chunk.remaining());
        t.setLastValueChunk(chunk);
        return new DefaultMutableTupleNode(t);
    }

    public static TupleNode encode(boolean bool) {
        return EncoderUtils.encode((TagEnum)UniversalTag.BOOLEAN, bool);
    }

    public static TupleNode encode(TagEnum tag, boolean bool) {
        Tuple t = new Tuple();
        t.setTag(tag, true);
        ByteBuffer chunk = ByteBuffer.wrap(PrimitiveUtils.encodeBoolean(bool));
        t.setLength(chunk.remaining());
        t.setLastValueChunk(chunk);
        return new DefaultMutableTupleNode(t);
    }
}

