/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.ldap.common.filter.ExprNode;

public abstract class AbstractExprNode
implements ExprNode {
    public static final int EQUALITY = 0;
    public static final int PRESENCE = 1;
    public static final int SUBSTRING = 2;
    public static final int GREATEREQ = 3;
    public static final int LESSEQ = 4;
    public static final int APPROXIMATE = 5;
    public static final int EXTENSIBLE = 6;
    public static final int SCOPE = 7;
    public static final int ASSERTION = 8;
    public static final int OR = 9;
    public static final int AND = 10;
    public static final int NOT = 11;
    private Map m_annotations;
    private final int m_assertionType;

    protected AbstractExprNode(int a_type) {
        this.m_assertionType = a_type;
        switch (this.m_assertionType) {
            case 5: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
    }

    public Object get(Object a_key) {
        if (null == this.getAnnotations()) {
            return null;
        }
        return this.getAnnotations().get(a_key);
    }

    public void set(Object a_key, Object a_value) {
        if (null == this.getAnnotations()) {
            this.m_annotations = new HashMap(2);
        }
        this.getAnnotations().put(a_key, a_value);
    }

    protected Map getAnnotations() {
        return this.m_annotations;
    }

    public final int getAssertionType() {
        return this.m_assertionType;
    }

    public static final String getOperationString(int a_assertionType) {
        String l_opstr = null;
        switch (a_assertionType) {
            case 5: {
                l_opstr = "~=";
                break;
            }
            case 0: {
                l_opstr = "=";
                break;
            }
            case 6: {
                l_opstr = "extensible";
                break;
            }
            case 3: {
                l_opstr = ">=";
                break;
            }
            case 4: {
                l_opstr = "<=";
                break;
            }
            case 1: {
                l_opstr = "=*";
                break;
            }
            case 2: {
                l_opstr = "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
        return l_opstr;
    }
}

