/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.BindRequest;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.util.ArrayUtils;

public class BindRequestImpl
extends AbstractRequest
implements BindRequest {
    private String name = "";
    private byte[] credentials;
    private boolean isSimple = true;
    private boolean isVersion3 = true;

    public BindRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean getSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.lockCheck("Attempt to alter auth. mode of locked BindRequest!");
        this.isSimple = isSimple;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setCredentials(byte[] credentials) {
        this.lockCheck("Attempt to alter auth. cred. of locked BindRequest!");
        this.credentials = credentials;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.lockCheck("Attempt to alter auth. DN of locked BindRequest!");
        this.name = name;
    }

    public boolean isVersion3() {
        return this.isVersion3;
    }

    public boolean getVersion3() {
        return this.isVersion3;
    }

    public void setVersion3(boolean isVersion3) {
        this.lockCheck("Attempt to alter proto. version of locked BindRequest!");
        this.isVersion3 = isVersion3;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BindRequest req = (BindRequest)obj;
        if (req.isSimple() != this.isSimple()) {
            return false;
        }
        if (req.isVersion3() != this.isVersion3()) {
            return false;
        }
        if (!req.getName().equals(this.getName())) {
            return false;
        }
        return ArrayUtils.isEquals(req.getCredentials(), this.getCredentials());
    }
}

