/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.IteratorNamingEnumeration;
import org.apache.ldap.common.message.LockableAttribute;

public class LockableAttributeImpl
extends AbstractLockable
implements LockableAttribute {
    private final String id;
    private final ArrayList list;

    public LockableAttributeImpl(Lockable parent, String id) {
        super(parent, false);
        this.id = id;
        this.list = new ArrayList();
    }

    public LockableAttributeImpl(String id, Object value) {
        super(false);
        this.id = id;
        this.list = new ArrayList();
        this.list.add(value);
    }

    public LockableAttributeImpl(String id, byte[] value) {
        super(false);
        this.id = id;
        this.list = new ArrayList();
        this.list.add(value);
    }

    public LockableAttributeImpl(String id) {
        super(false);
        this.id = id;
        this.list = new ArrayList();
    }

    private LockableAttributeImpl(Lockable parent, String id, ArrayList list) {
        super(parent, false);
        this.id = id;
        this.list = list;
    }

    private LockableAttributeImpl(String id, ArrayList list) {
        super(false);
        this.id = id;
        this.list = list;
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(this.list.iterator());
    }

    public Object get() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public int size() {
        return this.list.size();
    }

    public String getID() {
        return this.id;
    }

    public boolean contains(Object attrVal) {
        return this.list.contains(attrVal);
    }

    public boolean add(Object attrVal) {
        super.lockCheck("Attempt to add value to locked Attribute!");
        return this.list.add(attrVal);
    }

    public boolean remove(Object attrVal) {
        super.lockCheck("Attempt to remove value from locked Attribute!");
        return this.list.remove(attrVal);
    }

    public void clear() {
        super.lockCheck("Attempt to clear values from locked Attribute!");
        this.list.clear();
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public Object clone() {
        ArrayList l_list = (ArrayList)this.list.clone();
        if (this.getParent() != null) {
            return new LockableAttributeImpl(this.getParent(), this.id, l_list);
        }
        return new LockableAttributeImpl(this.id, l_list);
    }

    public boolean isOrdered() {
        return true;
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object remove(int index) {
        super.lockCheck("Attempt to remove value from locked Attribute!");
        return this.list.remove(index);
    }

    public void add(int index, Object attrVal) {
        super.lockCheck("Attempt to add value to locked Attribute!");
        this.list.add(index, attrVal);
    }

    public Object set(int index, Object attrVal) {
        super.lockCheck("Attempt to set value in locked Attribute!");
        return this.list.set(index, attrVal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attr = (Attribute)obj;
        if (!this.id.equals(attr.getID())) {
            return false;
        }
        if (attr.size() != this.list.size()) {
            return false;
        }
        for (int ii = 0; ii < attr.size(); ++ii) {
            try {
                if (this.list.contains(attr.get(ii))) continue;
                return false;
            }
            catch (NamingException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

