/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.util.ValuedEnum;

public class ResultCodeEnum
extends ValuedEnum {
    public static final int SUCCESS_VAL = 0;
    public static final int OPERATIONSERROR_VAL = 1;
    public static final int PROTOCOLERROR_VAL = 2;
    public static final int TIMELIMITEXCEEDED_VAL = 3;
    public static final int SIZELIMITEXCEEDED_VAL = 4;
    public static final int COMPAREFALSE_VAL = 5;
    public static final int COMPARETRUE_VAL = 6;
    public static final int AUTHMETHODNOTSUPPORTED_VAL = 7;
    public static final int STRONGAUTHREQUIRED_VAL = 8;
    public static final int PARTIALRESULTS_VAL = 9;
    public static final int REFERRAL_VAL = 10;
    public static final int ADMINLIMITEXCEEDED_VAL = 11;
    public static final int UNAVAILABLECRITICALEXTENSION_VAL = 12;
    public static final int CONFIDENTIALITYREQUIRED_VAL = 13;
    public static final int SASLBINDINPROGRESS_VAL = 14;
    public static final int NOSUCHATTRIBUTE_VAL = 16;
    public static final int UNDEFINEDATTRIBUTETYPE_VAL = 17;
    public static final int INAPPROPRIATEMATCHING_VAL = 18;
    public static final int CONSTRAINTVIOLATION_VAL = 19;
    public static final int ATTRIBUTEORVALUEEXISTS_VAL = 20;
    public static final int INVALIDATTRIBUTESYNTAX_VAL = 21;
    public static final int NOSUCHOBJECT_VAL = 32;
    public static final int ALIASPROBLEM_VAL = 33;
    public static final int INVALIDDNSYNTAX_VAL = 34;
    public static final int ALIASDEREFERENCINGPROBLEM_VAL = 36;
    public static final int INAPPROPRIATEAUTHENTICATION_VAL = 48;
    public static final int INVALIDCREDENTIALS_VAL = 49;
    public static final int INSUFFICIENTACCESSRIGHTS_VAL = 50;
    public static final int BUSY_VAL = 51;
    public static final int UNAVAILABLE_VAL = 52;
    public static final int UNWILLINGTOPERFORM_VAL = 53;
    public static final int LOOPDETECT_VAL = 54;
    public static final int NAMINGVIOLATION_VAL = 64;
    public static final int NOTALLOWEDONNONLEAF_VAL = 66;
    public static final int OBJECTCLASSVIOLATION_VAL = 65;
    public static final int NOTALLOWEDONRDN_VAL = 67;
    public static final int ENTRYALREADYEXISTS_VAL = 68;
    public static final int OBJECTCLASSMODSPROHIBITED_VAL = 69;
    public static final int AFFECTSMULTIPLEDSAS_VAL = 71;
    public static final int OTHER_VAL = 80;
    public static final ResultCodeEnum PARTIALRESULTS = new ResultCodeEnum("PARTIALRESULTS", 9);
    public static final ResultCodeEnum SUCCESS = new ResultCodeEnum("SUCCESS", 0);
    public static final ResultCodeEnum COMPAREFALSE = new ResultCodeEnum("COMPAREFALSE", 5);
    public static final ResultCodeEnum COMPARETRUE = new ResultCodeEnum("COMPARETRUE", 6);
    public static final ResultCodeEnum REFERRAL = new ResultCodeEnum("REFERRAL", 10);
    public static final ResultCodeEnum SASLBINDINPROGRESS = new ResultCodeEnum("SASLBINDINPROGRESS", 14);
    public static final ResultCodeEnum AUTHMETHODNOTSUPPORTED = new ResultCodeEnum("AUTHMETHODNOTSUPPORTED", 7);
    public static final ResultCodeEnum STRONGAUTHREQUIRED = new ResultCodeEnum("STRONGAUTHREQUIRED", 8);
    public static final ResultCodeEnum CONFIDENTIALITYREQUIRED = new ResultCodeEnum("CONFIDENTIALITYREQUIRED", 13);
    public static final ResultCodeEnum ALIASDEREFERENCINGPROBLEM = new ResultCodeEnum("ALIASDEREFERENCINGPROBLEM", 36);
    public static final ResultCodeEnum INAPPROPRIATEAUTHENTICATION = new ResultCodeEnum("INAPPROPRIATEAUTHENTICATION", 48);
    public static final ResultCodeEnum INVALIDCREDENTIALS = new ResultCodeEnum("INVALIDCREDENTIALS", 49);
    public static final ResultCodeEnum INSUFFICIENTACCESSRIGHTS = new ResultCodeEnum("INSUFFICIENTACCESSRIGHTS", 50);
    public static final ResultCodeEnum OPERATIONSERROR = new ResultCodeEnum("OPERATIONSERROR", 1);
    public static final ResultCodeEnum PROTOCOLERROR = new ResultCodeEnum("PROTOCOLERROR", 2);
    public static final ResultCodeEnum TIMELIMITEXCEEDED = new ResultCodeEnum("TIMELIMITEXCEEDED", 3);
    public static final ResultCodeEnum SIZELIMITEXCEEDED = new ResultCodeEnum("SIZELIMITEXCEEDED", 4);
    public static final ResultCodeEnum ADMINLIMITEXCEEDED = new ResultCodeEnum("ADMINLIMITEXCEEDED", 11);
    public static final ResultCodeEnum UNAVAILABLECRITICALEXTENSION = new ResultCodeEnum("UNAVAILABLECRITICALEXTENSION", 12);
    public static final ResultCodeEnum BUSY = new ResultCodeEnum("BUSY", 51);
    public static final ResultCodeEnum UNAVAILABLE = new ResultCodeEnum("UNAVAILABLE", 52);
    public static final ResultCodeEnum UNWILLINGTOPERFORM = new ResultCodeEnum("UNWILLINGTOPERFORM", 53);
    public static final ResultCodeEnum LOOPDETECT = new ResultCodeEnum("LOOPDETECT", 54);
    public static final ResultCodeEnum NOSUCHATTRIBUTE = new ResultCodeEnum("NOSUCHATTRIBUTE", 16);
    public static final ResultCodeEnum UNDEFINEDATTRIBUTETYPE = new ResultCodeEnum("UNDEFINEDATTRIBUTETYPE", 17);
    public static final ResultCodeEnum INAPPROPRIATEMATCHING = new ResultCodeEnum("INAPPROPRIATEMATCHING", 18);
    public static final ResultCodeEnum CONSTRAINTVIOLATION = new ResultCodeEnum("CONSTRAINTVIOLATION", 19);
    public static final ResultCodeEnum ATTRIBUTEORVALUEEXISTS = new ResultCodeEnum("ATTRIBUTEORVALUEEXISTS", 20);
    public static final ResultCodeEnum INVALIDATTRIBUTESYNTAX = new ResultCodeEnum("INVALIDATTRIBUTESYNTAX", 21);
    public static final ResultCodeEnum NOSUCHOBJECT = new ResultCodeEnum("NOSUCHOBJECT", 32);
    public static final ResultCodeEnum ALIASPROBLEM = new ResultCodeEnum("ALIASPROBLEM", 33);
    public static final ResultCodeEnum INVALIDDNSYNTAX = new ResultCodeEnum("INVALIDDNSYNTAX", 34);
    public static final ResultCodeEnum NAMINGVIOLATION = new ResultCodeEnum("NAMINGVIOLATION", 64);
    public static final ResultCodeEnum OBJECTCLASSVIOLATION = new ResultCodeEnum("OBJECTCLASSVIOLATION", 65);
    public static final ResultCodeEnum NOTALLOWEDONNONLEAF = new ResultCodeEnum("NOTALLOWEDONNONLEAF", 66);
    public static final ResultCodeEnum NOTALLOWEDONRDN = new ResultCodeEnum("NOTALLOWEDONRDN", 67);
    public static final ResultCodeEnum ENTRYALREADYEXISTS = new ResultCodeEnum("ENTRYALREADYEXISTS", 68);
    public static final ResultCodeEnum OBJECTCLASSMODSPROHIBITED = new ResultCodeEnum("OBJECTCLASSMODSPROHIBITE", 69);
    public static final ResultCodeEnum AFFECTSMULTIPLEDSAS = new ResultCodeEnum("AFFECTSMULTIPLEDSAS", 71);
    public static final ResultCodeEnum OTHER = new ResultCodeEnum("OTHER", 80);
    public static final Set GENERAL_CODES = Collections.singleton(OTHER);
    public static final Set NON_ERRONEOUS_CODES;
    public static final Set ATTRIBUTE_CODES;
    public static final Set NAME_CODES;
    public static final Set SECURITY_CODES;
    public static final Set SERVICE_CODES;
    public static final Set UPDATE_CODES;
    public static final Set COMMON_CODES;
    public static final Set BIND_CODES;
    public static final Set SEARCH_CODES;
    public static final Set MODIFY_CODES;
    public static final Set ADD_CODES;
    public static final Set DELETE_CODES;
    public static final Set MODIFYDN_CODES;
    public static final Set COMPARE_CODES;
    public static final Set EXTENDED_CODES;
    public static final Set ALL_CODES;
    public static final Set NAMINGEXCEPTION_CODES;
    public static final Set AUTHENTICATIONNOTSUPPOERTEDEXCEPTION_CODES;
    public static final Set SERVICEUNAVAILABLE_CODES;
    public static final Set INVALIDATTRIBUTEVALUEEXCEPTION_CODES;
    public static final Set PARTIALRESULTSEXCEPTION_CODES;
    public static final Set LIMITEXCEEDEDEXCEPTION_CODES;
    public static final Set OPERATIONNOTSUPPOERTEXCEPTION_CODES;
    public static final Set INVALIDNAMEEXCEPTION_CODES;
    public static final Set SCHEMAVIOLATIONEXCEPTION_CODES;

    private ResultCodeEnum(String a_name, int a_value) {
        super(a_name, a_value);
    }

    public static Set getGeneralCodes() {
        return GENERAL_CODES;
    }

    public static Set getNonErroneousCodes() {
        return NON_ERRONEOUS_CODES;
    }

    public static Set getAttributeCodes() {
        return ATTRIBUTE_CODES;
    }

    public static Set getNameCodes() {
        return NAME_CODES;
    }

    public static Set getSecurityCodes() {
        return SECURITY_CODES;
    }

    public static Set getServiceCodes() {
        return SERVICE_CODES;
    }

    public static Set getUpdateCodes() {
        return UPDATE_CODES;
    }

    public static Set getCommonCodes() {
        return COMMON_CODES;
    }

    public static Set getBindCodes() {
        return BIND_CODES;
    }

    public static Set getSearchCodes() {
        return SEARCH_CODES;
    }

    public static Set getModifyCodes() {
        return MODIFY_CODES;
    }

    public static Set getAddCodes() {
        return ADD_CODES;
    }

    public static Set getDeleteCodes() {
        return DELETE_CODES;
    }

    public static Set getModifyDnCodes() {
        return MODIFYDN_CODES;
    }

    public static Set getCompareCodes() {
        return COMPARE_CODES;
    }

    public static Set getExtendedCodes() {
        return EXTENDED_CODES;
    }

    public static Set getAllCodes() {
        return ALL_CODES;
    }

    public static ResultCodeEnum getResultCodeEnum(int value) {
        switch (value) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONSERROR;
            }
            case 2: {
                return PROTOCOLERROR;
            }
            case 3: {
                return TIMELIMITEXCEEDED;
            }
            case 4: {
                return SIZELIMITEXCEEDED;
            }
            case 5: {
                return COMPAREFALSE;
            }
            case 6: {
                return COMPARETRUE;
            }
            case 7: {
                return AUTHMETHODNOTSUPPORTED;
            }
            case 8: {
                return STRONGAUTHREQUIRED;
            }
            case 9: {
                return PARTIALRESULTS;
            }
            case 10: {
                return REFERRAL;
            }
            case 11: {
                return ADMINLIMITEXCEEDED;
            }
            case 12: {
                return UNAVAILABLECRITICALEXTENSION;
            }
            case 13: {
                return CONFIDENTIALITYREQUIRED;
            }
            case 14: {
                return SASLBINDINPROGRESS;
            }
            case 16: {
                return NOSUCHATTRIBUTE;
            }
            case 17: {
                return UNDEFINEDATTRIBUTETYPE;
            }
            case 18: {
                return INAPPROPRIATEMATCHING;
            }
            case 19: {
                return CONSTRAINTVIOLATION;
            }
            case 20: {
                return ATTRIBUTEORVALUEEXISTS;
            }
            case 21: {
                return INVALIDATTRIBUTESYNTAX;
            }
            case 32: {
                return NOSUCHOBJECT;
            }
            case 33: {
                return ALIASPROBLEM;
            }
            case 34: {
                return INVALIDDNSYNTAX;
            }
            case 36: {
                return ALIASDEREFERENCINGPROBLEM;
            }
            case 48: {
                return INAPPROPRIATEAUTHENTICATION;
            }
            case 49: {
                return INVALIDCREDENTIALS;
            }
            case 50: {
                return INSUFFICIENTACCESSRIGHTS;
            }
            case 51: {
                return BUSY;
            }
            case 52: {
                return UNAVAILABLE;
            }
            case 53: {
                return UNWILLINGTOPERFORM;
            }
            case 54: {
                return LOOPDETECT;
            }
            case 64: {
                return NAMINGVIOLATION;
            }
            case 65: {
                return OBJECTCLASSVIOLATION;
            }
            case 66: {
                return NOTALLOWEDONNONLEAF;
            }
            case 67: {
                return NOTALLOWEDONRDN;
            }
            case 68: {
                return ENTRYALREADYEXISTS;
            }
            case 69: {
                return OBJECTCLASSMODSPROHIBITED;
            }
            case 71: {
                return AFFECTSMULTIPLEDSAS;
            }
            case 80: {
                return OTHER;
            }
        }
        return null;
    }

    public static ResultCodeEnum getBestEstimate(Throwable t, MessageTypeEnum type) {
        Set set = ResultCodeEnum.getResultCodes(t);
        if (set.isEmpty()) {
            return OTHER;
        }
        if (set.size() == 1) {
            return (ResultCodeEnum)set.iterator().next();
        }
        if (type == null) {
            HashSet tmp = new HashSet();
            tmp.addAll(set);
            tmp.removeAll(NON_ERRONEOUS_CODES);
            if (tmp.isEmpty()) {
                return OTHER;
            }
            return (ResultCodeEnum)tmp.iterator().next();
        }
        Set candidates = Collections.EMPTY_SET;
        switch (type.getValue()) {
            case 0x40000010: {
                return (ResultCodeEnum)set.iterator().next();
            }
            case 0x40000008: {
                candidates = ResultCodeEnum.intersection(set, ADD_CODES);
                break;
            }
            case 0x40000009: {
                candidates = ResultCodeEnum.intersection(set, ADD_CODES);
                break;
            }
            case 0x40000000: {
                candidates = ResultCodeEnum.intersection(set, BIND_CODES);
                break;
            }
            case 0x40000001: {
                candidates = ResultCodeEnum.intersection(set, BIND_CODES);
                break;
            }
            case 0x4000000E: {
                candidates = ResultCodeEnum.intersection(set, COMPARE_CODES);
                break;
            }
            case 0x4000000F: {
                candidates = ResultCodeEnum.intersection(set, COMPARE_CODES);
                break;
            }
            case 0x4000000A: {
                candidates = ResultCodeEnum.intersection(set, DELETE_CODES);
                break;
            }
            case 0x4000000B: {
                candidates = ResultCodeEnum.intersection(set, DELETE_CODES);
                break;
            }
            case 1073741847: {
                candidates = ResultCodeEnum.intersection(set, EXTENDED_CODES);
                break;
            }
            case 1073741848: {
                candidates = ResultCodeEnum.intersection(set, EXTENDED_CODES);
                break;
            }
            case 0x4000000C: {
                candidates = ResultCodeEnum.intersection(set, MODIFYDN_CODES);
                break;
            }
            case 0x4000000D: {
                candidates = ResultCodeEnum.intersection(set, MODIFYDN_CODES);
                break;
            }
            case 0x40000006: {
                candidates = ResultCodeEnum.intersection(set, MODIFY_CODES);
                break;
            }
            case 0x40000007: {
                candidates = ResultCodeEnum.intersection(set, MODIFY_CODES);
                break;
            }
            case 0x40000003: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case 0x40000005: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case 0x40000004: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case 1073741843: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case 0x40000002: {
                return (ResultCodeEnum)set.iterator().next();
            }
        }
        candidates.removeAll(NON_ERRONEOUS_CODES);
        if (candidates.isEmpty()) {
            return OTHER;
        }
        return (ResultCodeEnum)candidates.iterator().next();
    }

    private static Set intersection(Set s1, Set s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet intersection = new HashSet();
        if (s1.size() <= s2.size()) {
            Iterator items = s1.iterator();
            while (items.hasNext()) {
                Object item = items.next();
                if (!s2.contains(item)) continue;
                intersection.add(item);
            }
        } else {
            Iterator items = s2.iterator();
            while (items.hasNext()) {
                Object item = items.next();
                if (!s1.contains(item)) continue;
                intersection.add(item);
            }
        }
        return intersection;
    }

    public static Set getResultCodes(Throwable t) {
        ResultCodeEnum rc = ResultCodeEnum.getResultCode(t);
        if (rc != null) {
            return Collections.singleton(rc);
        }
        if (t instanceof SchemaViolationException) {
            return SCHEMAVIOLATIONEXCEPTION_CODES;
        }
        if (t instanceof InvalidNameException) {
            return INVALIDNAMEEXCEPTION_CODES;
        }
        if (t instanceof OperationNotSupportedException) {
            return OPERATIONNOTSUPPOERTEXCEPTION_CODES;
        }
        if (t instanceof LimitExceededException) {
            return LIMITEXCEEDEDEXCEPTION_CODES;
        }
        if (t instanceof PartialResultException) {
            return PARTIALRESULTSEXCEPTION_CODES;
        }
        if (t instanceof InvalidAttributeValueException) {
            return INVALIDATTRIBUTEVALUEEXCEPTION_CODES;
        }
        if (t instanceof ServiceUnavailableException) {
            return SERVICEUNAVAILABLE_CODES;
        }
        if (t instanceof AuthenticationNotSupportedException) {
            return AUTHENTICATIONNOTSUPPOERTEDEXCEPTION_CODES;
        }
        if (t instanceof NamingException) {
            return NAMINGEXCEPTION_CODES;
        }
        return Collections.EMPTY_SET;
    }

    public static ResultCodeEnum getResultCode(Throwable t) {
        if (t instanceof LdapException) {
            return ((LdapException)((Object)t)).getResultCode();
        }
        if (t instanceof CommunicationException) {
            return PROTOCOLERROR;
        }
        if (t instanceof TimeLimitExceededException) {
            return TIMELIMITEXCEEDED;
        }
        if (t instanceof SizeLimitExceededException) {
            return SIZELIMITEXCEEDED;
        }
        if (t instanceof AuthenticationException) {
            return INVALIDCREDENTIALS;
        }
        if (t instanceof NoPermissionException) {
            return INSUFFICIENTACCESSRIGHTS;
        }
        if (t instanceof NoSuchAttributeException) {
            return NOSUCHATTRIBUTE;
        }
        if (t instanceof InvalidAttributeIdentifierException) {
            return UNDEFINEDATTRIBUTETYPE;
        }
        if (t instanceof InvalidSearchFilterException) {
            return INAPPROPRIATEMATCHING;
        }
        if (t instanceof AttributeInUseException) {
            return ATTRIBUTEORVALUEEXISTS;
        }
        if (t instanceof NameNotFoundException) {
            return NOSUCHOBJECT;
        }
        if (t instanceof NameAlreadyBoundException) {
            return ENTRYALREADYEXISTS;
        }
        if (t instanceof ContextNotEmptyException) {
            return NOTALLOWEDONNONLEAF;
        }
        return null;
    }

    static {
        HashSet<ResultCodeEnum> set = new HashSet<ResultCodeEnum>();
        set.add(SUCCESS);
        set.add(COMPARETRUE);
        set.add(COMPAREFALSE);
        set.add(REFERRAL);
        set.add(SASLBINDINPROGRESS);
        NON_ERRONEOUS_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(NOSUCHATTRIBUTE);
        set.add(UNDEFINEDATTRIBUTETYPE);
        set.add(INAPPROPRIATEMATCHING);
        set.add(CONSTRAINTVIOLATION);
        set.add(ATTRIBUTEORVALUEEXISTS);
        set.add(INVALIDATTRIBUTESYNTAX);
        ATTRIBUTE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(NOSUCHOBJECT);
        set.add(ALIASPROBLEM);
        set.add(INVALIDDNSYNTAX);
        NAME_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(INVALIDCREDENTIALS);
        set.add(STRONGAUTHREQUIRED);
        set.add(AUTHMETHODNOTSUPPORTED);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(ALIASDEREFERENCINGPROBLEM);
        set.add(INAPPROPRIATEAUTHENTICATION);
        SECURITY_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOLERROR);
        set.add(OPERATIONSERROR);
        set.add(TIMELIMITEXCEEDED);
        set.add(SIZELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(UNWILLINGTOPERFORM);
        set.add(UNAVAILABLECRITICALEXTENSION);
        SERVICE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(NAMINGVIOLATION);
        set.add(OBJECTCLASSVIOLATION);
        set.add(NOTALLOWEDONNONLEAF);
        set.add(NOTALLOWEDONRDN);
        set.add(ENTRYALREADYEXISTS);
        set.add(OBJECTCLASSMODSPROHIBITED);
        set.add(AFFECTSMULTIPLEDSAS);
        UPDATE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOLERROR);
        set.add(TIMELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(STRONGAUTHREQUIRED);
        set.add(UNWILLINGTOPERFORM);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(UNAVAILABLECRITICALEXTENSION);
        COMMON_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOLERROR);
        set.add(INVALIDDNSYNTAX);
        set.add(TIMELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(UNWILLINGTOPERFORM);
        set.add(SASLBINDINPROGRESS);
        set.add(STRONGAUTHREQUIRED);
        set.add(INVALIDCREDENTIALS);
        set.add(AUTHMETHODNOTSUPPORTED);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INAPPROPRIATEAUTHENTICATION);
        set.add(UNAVAILABLECRITICALEXTENSION);
        BIND_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(NOSUCHOBJECT);
        set.add(ALIASPROBLEM);
        set.add(PROTOCOLERROR);
        set.add(INVALIDDNSYNTAX);
        set.add(SIZELIMITEXCEEDED);
        set.add(TIMELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(STRONGAUTHREQUIRED);
        set.add(UNWILLINGTOPERFORM);
        set.add(INAPPROPRIATEMATCHING);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(ALIASDEREFERENCINGPROBLEM);
        set.add(UNAVAILABLECRITICALEXTENSION);
        SEARCH_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(NOSUCHOBJECT);
        set.add(PROTOCOLERROR);
        set.add(INVALIDDNSYNTAX);
        set.add(NOTALLOWEDONRDN);
        set.add(NOSUCHATTRIBUTE);
        set.add(TIMELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(STRONGAUTHREQUIRED);
        set.add(UNWILLINGTOPERFORM);
        set.add(CONSTRAINTVIOLATION);
        set.add(OBJECTCLASSVIOLATION);
        set.add(INVALIDATTRIBUTESYNTAX);
        set.add(UNDEFINEDATTRIBUTETYPE);
        set.add(ATTRIBUTEORVALUEEXISTS);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(OBJECTCLASSMODSPROHIBITED);
        set.add(UNAVAILABLECRITICALEXTENSION);
        MODIFY_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(NOSUCHOBJECT);
        set.add(PROTOCOLERROR);
        set.add(NAMINGVIOLATION);
        set.add(INVALIDDNSYNTAX);
        set.add(TIMELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(STRONGAUTHREQUIRED);
        set.add(UNWILLINGTOPERFORM);
        set.add(ENTRYALREADYEXISTS);
        set.add(CONSTRAINTVIOLATION);
        set.add(OBJECTCLASSVIOLATION);
        set.add(INVALIDATTRIBUTESYNTAX);
        set.add(ATTRIBUTEORVALUEEXISTS);
        set.add(UNDEFINEDATTRIBUTETYPE);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(UNAVAILABLECRITICALEXTENSION);
        ADD_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(NOSUCHOBJECT);
        set.add(PROTOCOLERROR);
        set.add(INVALIDDNSYNTAX);
        set.add(TIMELIMITEXCEEDED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(STRONGAUTHREQUIRED);
        set.add(UNWILLINGTOPERFORM);
        set.add(NOTALLOWEDONNONLEAF);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(UNAVAILABLECRITICALEXTENSION);
        DELETE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOPDETECT);
        set.add(UNAVAILABLE);
        set.add(NOSUCHOBJECT);
        set.add(PROTOCOLERROR);
        set.add(INVALIDDNSYNTAX);
        set.add(NAMINGVIOLATION);
        set.add(TIMELIMITEXCEEDED);
        set.add(ENTRYALREADYEXISTS);
        set.add(ADMINLIMITEXCEEDED);
        set.add(STRONGAUTHREQUIRED);
        set.add(UNWILLINGTOPERFORM);
        set.add(NOTALLOWEDONNONLEAF);
        set.add(AFFECTSMULTIPLEDSAS);
        set.add(CONSTRAINTVIOLATION);
        set.add(OBJECTCLASSVIOLATION);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(UNAVAILABLECRITICALEXTENSION);
        MODIFYDN_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OPERATIONSERROR);
        set.add(PROTOCOLERROR);
        set.add(TIMELIMITEXCEEDED);
        set.add(COMPAREFALSE);
        set.add(COMPARETRUE);
        set.add(STRONGAUTHREQUIRED);
        set.add(ADMINLIMITEXCEEDED);
        set.add(UNAVAILABLECRITICALEXTENSION);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(NOSUCHATTRIBUTE);
        set.add(INVALIDATTRIBUTESYNTAX);
        set.add(NOSUCHOBJECT);
        set.add(INVALIDDNSYNTAX);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLINGTOPERFORM);
        set.add(LOOPDETECT);
        set.add(REFERRAL);
        set.add(OTHER);
        COMPARE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(SUCCESS);
        set.add(OPERATIONSERROR);
        set.add(PROTOCOLERROR);
        set.add(TIMELIMITEXCEEDED);
        set.add(SIZELIMITEXCEEDED);
        set.add(COMPAREFALSE);
        set.add(COMPARETRUE);
        set.add(AUTHMETHODNOTSUPPORTED);
        set.add(STRONGAUTHREQUIRED);
        set.add(REFERRAL);
        set.add(ADMINLIMITEXCEEDED);
        set.add(UNAVAILABLECRITICALEXTENSION);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(SASLBINDINPROGRESS);
        set.add(NOSUCHATTRIBUTE);
        set.add(UNDEFINEDATTRIBUTETYPE);
        set.add(INAPPROPRIATEMATCHING);
        set.add(CONSTRAINTVIOLATION);
        set.add(ATTRIBUTEORVALUEEXISTS);
        set.add(INVALIDATTRIBUTESYNTAX);
        set.add(NOSUCHOBJECT);
        set.add(ALIASPROBLEM);
        set.add(INVALIDDNSYNTAX);
        set.add(ALIASDEREFERENCINGPROBLEM);
        set.add(INAPPROPRIATEAUTHENTICATION);
        set.add(INVALIDCREDENTIALS);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLINGTOPERFORM);
        set.add(LOOPDETECT);
        set.add(NAMINGVIOLATION);
        set.add(OBJECTCLASSVIOLATION);
        set.add(NOTALLOWEDONNONLEAF);
        set.add(NOTALLOWEDONRDN);
        set.add(ENTRYALREADYEXISTS);
        set.add(OBJECTCLASSMODSPROHIBITED);
        set.add(AFFECTSMULTIPLEDSAS);
        set.add(OTHER);
        EXTENDED_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(SUCCESS);
        set.add(OPERATIONSERROR);
        set.add(PROTOCOLERROR);
        set.add(TIMELIMITEXCEEDED);
        set.add(SIZELIMITEXCEEDED);
        set.add(COMPAREFALSE);
        set.add(COMPARETRUE);
        set.add(AUTHMETHODNOTSUPPORTED);
        set.add(STRONGAUTHREQUIRED);
        set.add(PARTIALRESULTS);
        set.add(REFERRAL);
        set.add(ADMINLIMITEXCEEDED);
        set.add(UNAVAILABLECRITICALEXTENSION);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(SASLBINDINPROGRESS);
        set.add(NOSUCHATTRIBUTE);
        set.add(UNDEFINEDATTRIBUTETYPE);
        set.add(INAPPROPRIATEMATCHING);
        set.add(CONSTRAINTVIOLATION);
        set.add(ATTRIBUTEORVALUEEXISTS);
        set.add(INVALIDATTRIBUTESYNTAX);
        set.add(NOSUCHOBJECT);
        set.add(ALIASPROBLEM);
        set.add(INVALIDDNSYNTAX);
        set.add(ALIASDEREFERENCINGPROBLEM);
        set.add(INAPPROPRIATEAUTHENTICATION);
        set.add(INVALIDCREDENTIALS);
        set.add(INSUFFICIENTACCESSRIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLINGTOPERFORM);
        set.add(LOOPDETECT);
        set.add(NAMINGVIOLATION);
        set.add(OBJECTCLASSVIOLATION);
        set.add(NOTALLOWEDONNONLEAF);
        set.add(NOTALLOWEDONRDN);
        set.add(ENTRYALREADYEXISTS);
        set.add(OBJECTCLASSMODSPROHIBITED);
        set.add(AFFECTSMULTIPLEDSAS);
        set.add(OTHER);
        ALL_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OPERATIONSERROR);
        set.add(ALIASPROBLEM);
        set.add(ALIASDEREFERENCINGPROBLEM);
        set.add(LOOPDETECT);
        set.add(AFFECTSMULTIPLEDSAS);
        set.add(OTHER);
        NAMINGEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(AUTHMETHODNOTSUPPORTED);
        set.add(STRONGAUTHREQUIRED);
        set.add(CONFIDENTIALITYREQUIRED);
        set.add(INAPPROPRIATEAUTHENTICATION);
        AUTHENTICATIONNOTSUPPOERTEDEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(UNAVAILABLE);
        SERVICEUNAVAILABLE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(CONSTRAINTVIOLATION);
        set.add(INVALIDATTRIBUTESYNTAX);
        INVALIDATTRIBUTEVALUEEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(PARTIALRESULTS);
        set.add(REFERRAL);
        PARTIALRESULTSEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(REFERRAL);
        set.add(ADMINLIMITEXCEEDED);
        LIMITEXCEEDEDEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(UNAVAILABLECRITICALEXTENSION);
        set.add(UNWILLINGTOPERFORM);
        OPERATIONNOTSUPPOERTEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(INVALIDDNSYNTAX);
        set.add(NAMINGVIOLATION);
        INVALIDNAMEEXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OBJECTCLASSVIOLATION);
        set.add(NOTALLOWEDONRDN);
        set.add(OBJECTCLASSMODSPROHIBITED);
        SCHEMAVIOLATIONEXCEPTION_CODES = Collections.unmodifiableSet(set);
    }
}

