/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ldap.common.filter.BranchNormalizedVisitor;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ScopeEnum;
import org.apache.ldap.common.message.SearchRequest;

public class SearchRequestImpl
extends AbstractRequest
implements SearchRequest {
    private String baseDn;
    private ExprNode filter;
    private ScopeEnum scope;
    private boolean typesOnly;
    private int sizeLimit;
    private int timeLimit;
    private DerefAliasesEnum derefAliases;
    private Collection attributes = new ArrayList();

    public SearchRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public String getBase() {
        return this.baseDn;
    }

    public void setBase(String base) {
        this.lockCheck("Attempt to alter search base of locked SearchRequest!");
        this.baseDn = base;
    }

    public DerefAliasesEnum getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(DerefAliasesEnum derefAliases) {
        this.lockCheck("Attempt to alter alias dereferencing mode of locked SearchRequest!");
        this.derefAliases = derefAliases;
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setFilter(ExprNode filter) {
        this.lockCheck("Attempt to alter search filter of locked SearchRequest!");
        this.filter = filter;
    }

    public MessageTypeEnum[] getResponseTypes() {
        return (MessageTypeEnum[])RESPONSE_TYPES.clone();
    }

    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.lockCheck("Attempt to alter search scope of locked SearchReqest!");
        this.scope = scope;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int entriesMax) {
        this.lockCheck("Attempt to alter size limit on locked SearchRequest!");
        this.sizeLimit = entriesMax;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int secondsMax) {
        this.lockCheck("Attempt to alter time limit on locked SearchRequest!");
        this.timeLimit = secondsMax;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.lockCheck("Attempt to alter typesOnly flag of locked SearchRequest!");
        this.typesOnly = typesOnly;
    }

    public void addAttribute(String attribute) {
        this.lockCheck("Attempt to add return attribute to locked SearchRequest!");
        this.attributes.add(attribute);
    }

    public void removeAttribute(String attribute) {
        this.lockCheck("Attempt to remove return attribute from locked SearchRequest!");
        this.attributes.remove(attribute);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SearchRequest req = (SearchRequest)obj;
        if (!req.getBase().equals(this.baseDn)) {
            return false;
        }
        if (req.getDerefAliases() != this.derefAliases) {
            return false;
        }
        if (req.getScope() != this.scope) {
            return false;
        }
        if (req.getSizeLimit() != this.sizeLimit) {
            return false;
        }
        if (req.getTimeLimit() != this.timeLimit) {
            return false;
        }
        if (req.getTypesOnly() != this.typesOnly) {
            return false;
        }
        if (req.getAttributes() == null && this.attributes != null && this.attributes.size() > 0) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes == null && req.getAttributes().size() > 0) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes != null) {
            if (req.getAttributes().size() != this.attributes.size()) {
                return false;
            }
            Iterator list = this.attributes.iterator();
            while (list.hasNext()) {
                if (req.getAttributes().contains(list.next())) continue;
                return false;
            }
        }
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        req.getFilter().accept(visitor);
        this.filter.accept(visitor);
        StringBuffer buf = new StringBuffer();
        this.filter.printToBuffer(buf);
        String myFilterString = buf.toString();
        buf.setLength(0);
        req.getFilter().printToBuffer(buf);
        String reqFilterString = buf.toString();
        return myFilterString.equals(reqFilterString);
    }
}

