/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.util;

import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class NamespaceTools {
    public static boolean isRoot(String a_dn) throws InvalidNameException {
        if (a_dn == null) {
            throw new InvalidNameException("A null DN is not a valid name.");
        }
        if (a_dn.indexOf(61) == -1) {
            throw new InvalidNameException("A DN should have an = sign.");
        }
        return a_dn.indexOf(44) == -1;
    }

    public static String getParent(String a_childDN) throws InvalidNameException {
        int l_index = -1;
        if (a_childDN == null) {
            throw new InvalidNameException("A null DN is not a valid name.");
        }
        if (a_childDN.indexOf(61) == -1) {
            throw new InvalidNameException("A DN should have an = sign.");
        }
        l_index = a_childDN.indexOf(44);
        if (l_index == -1) {
            return null;
        }
        return a_childDN.substring(l_index + 1);
    }

    public static String getNamespaceString(Name a_name) throws InvalidNameException {
        if (a_name instanceof CompositeName) {
            if (a_name.size() > 1) {
                throw new InvalidNameException(a_name.toString() + " has more components than namespace can handle");
            }
            return a_name.get(0);
        }
        return a_name.toString();
    }

    public static String getNamespaceString(String a_base, Name a_name) throws InvalidNameException {
        if (a_name instanceof CompositeName) {
            if (a_name.size() > 1) {
                throw new InvalidNameException(a_name.toString() + " has more components than namespace can handle");
            }
            StringBuffer l_buf = new StringBuffer(a_base);
            l_buf.append(',');
            l_buf.append(a_name.get(0));
            return l_buf.toString();
        }
        return a_name.toString();
    }

    public static String getLastComponent(String a_name) {
        if (null == a_name) {
            return null;
        }
        int l_commaIndex = -1;
        l_commaIndex = a_name.lastIndexOf(44);
        if (l_commaIndex == -1) {
            return a_name;
        }
        return a_name.substring(l_commaIndex);
    }

    public static String getRdn(String a_name) {
        if (null == a_name) {
            return null;
        }
        int l_commaIndex = -1;
        l_commaIndex = a_name.indexOf(44);
        if (l_commaIndex == -1) {
            return a_name;
        }
        return a_name.substring(0, l_commaIndex);
    }

    public static String setRdn(String a_name, String a_rdn) {
        if (null == a_name) {
            return null;
        }
        int l_commaIndex = -1;
        l_commaIndex = a_name.indexOf(44);
        if (l_commaIndex == -1) {
            return a_name;
        }
        StringBuffer l_suffix = new StringBuffer();
        l_suffix.append(a_name.substring(l_commaIndex, a_name.length()));
        l_suffix.insert(0, a_rdn);
        return l_suffix.toString();
    }

    public static String getRdnAttribute(String a_rdn) {
        int l_index = a_rdn.indexOf(61);
        return a_rdn.substring(0, l_index);
    }

    public static String getRdnValue(String a_rdn) {
        int l_index = a_rdn.indexOf(61);
        return a_rdn.substring(l_index + 1, a_rdn.length());
    }

    public static boolean isSibling(Name a_name1, Name a_name2) {
        if (a_name1.size() == a_name2.size()) {
            return a_name2.startsWith(a_name1.getSuffix(1));
        }
        return false;
    }

    public static boolean isDescendant(Name a_ancestor, Name a_descendant) {
        return a_descendant.startsWith(a_ancestor);
    }
}

