/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.ldap.common.exception.LdapConfigurationException;
import org.apache.ldap.common.ldif.LdifIterator;
import org.apache.ldap.common.ldif.LdifParserImpl;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.name.LdapName;

public abstract class AbstractCoreTest
extends TestCase {
    public static final String LDIF = "dn: uid=akarasulu,ou=users,ou=system\ncn: Alex Karasulu\nsn: Karasulu\ngivenname: Alex\nobjectclass: top\nobjectclass: person\nobjectclass: organizationalPerson\nobjectclass: inetOrgPerson\nou: Engineering\nou: People\nl: Bogusville\nuid: akarasulu\nmail: akarasulu@apache.org\ntelephonenumber: +1 408 555 4798\nfacsimiletelephonenumber: +1 408 555 9751\nroomnumber: 4612\nuserpassword: test\n";
    protected LdapContext sysRoot;
    protected boolean doDelete = true;
    protected Hashtable extras = new Hashtable();
    protected Hashtable overrides = new Hashtable();
    private ArrayList list = new ArrayList();

    public AbstractCoreTest() {
        LockableAttributesImpl attributes = new LockableAttributesImpl();
        LdifParserImpl parser = new LdifParserImpl();
        try {
            parser.parse(attributes, LDIF);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new NestableRuntimeException(e);
        }
        this.list.add(attributes);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.extras.put("server.test.entries", this.list);
        if (this.overrides.containsKey("server.wkdir")) {
            this.doDelete(new File((String)this.overrides.get("server.wkdir")));
        } else {
            this.doDelete(new File("target" + File.separator + "apacheds"));
        }
        this.setSysRoot("uid=admin,ou=system", "secret");
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                FileUtils.deleteDirectory(wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    protected LdapContext setSysRoot(String user, String passwd) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", passwd);
        return this.setSysRoot(env);
    }

    protected LdapContext setSysRoot(Hashtable env) throws NamingException {
        Hashtable<String, String> envFinal = new Hashtable<String, String>();
        envFinal.putAll(this.extras);
        envFinal.putAll(env);
        envFinal.put("java.naming.provider.url", "ou=system");
        envFinal.put("server.wkdir", "target" + File.separator + "apacheds");
        envFinal.put("java.naming.factory.initial", "org.apache.ldap.server.jndi.CoreContextFactory");
        envFinal.putAll(this.overrides);
        this.sysRoot = new InitialLdapContext(envFinal, null);
        return this.sysRoot;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ou=system");
        env.put("java.naming.factory.initial", "org.apache.ldap.server.jndi.CoreContextFactory");
        env.put("server.operation.shutdown", "");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialContext(env);
        }
        catch (Exception exception) {}
        this.sysRoot = null;
        Runtime.getRuntime().gc();
    }

    protected void importLdif(InputStream in) throws NamingException {
        Hashtable env = new Hashtable();
        env.putAll(this.sysRoot.getEnvironment());
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        LdifParserImpl parser = new LdifParserImpl();
        try {
            LdifIterator iterator = new LdifIterator(in);
            while (iterator.hasNext()) {
                LockableAttributesImpl attributes = new LockableAttributesImpl();
                String ldif = (String)iterator.next();
                parser.parse(attributes, ldif);
                LdapName dn = new LdapName((String)attributes.remove("dn").get());
                dn.remove(0);
                ctx.createSubcontext(dn, (Attributes)attributes);
            }
        }
        catch (Exception e) {
            String msg = "failed while trying to parse system ldif file";
            LdapConfigurationException ne = new LdapConfigurationException(msg);
            ne.setRootCause(e);
            throw ne;
        }
    }
}

