/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.authn;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.exception.LdapAuthenticationException;
import org.apache.ldap.common.exception.LdapAuthenticationNotSupportedException;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.util.StringTools;
import org.apache.ldap.server.authn.AbstractAuthenticator;
import org.apache.ldap.server.authn.AnonymousAuthenticator;
import org.apache.ldap.server.authn.Authenticator;
import org.apache.ldap.server.authn.AuthenticatorConfigBuilder;
import org.apache.ldap.server.authn.GenericAuthenticatorConfig;
import org.apache.ldap.server.authn.GenericAuthenticatorContext;
import org.apache.ldap.server.authn.LdapPrincipal;
import org.apache.ldap.server.authn.SimpleAuthenticator;
import org.apache.ldap.server.interceptor.Interceptor;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Invocation;
import org.apache.ldap.server.jndi.ServerLdapContext;

public class AuthenticationService
implements Interceptor {
    private static final String AUTH_TYPE = "java.naming.security.authentication";
    private static final String CREDS = "java.naming.security.credentials";
    public Map authenticators = new LinkedHashMap();

    public void init(InterceptorContext ctx) throws NamingException {
        boolean allowAnonymous = !ctx.getEnvironment().containsKey("server.disable.anonymous");
        GenericAuthenticatorContext authenticatorContext = new GenericAuthenticatorContext();
        authenticatorContext.setPartitionNexus(ctx.getRootNexus());
        authenticatorContext.setAllowAnonymous(allowAnonymous);
        try {
            GenericAuthenticatorConfig authenticatorConfig = new GenericAuthenticatorConfig();
            authenticatorConfig.setAuthenticatorName("none");
            authenticatorConfig.setAuthenticatorContext(authenticatorContext);
            AbstractAuthenticator authenticator = new AnonymousAuthenticator();
            authenticator.init(authenticatorConfig);
            this.register(authenticator);
            authenticatorConfig = new GenericAuthenticatorConfig();
            authenticatorConfig.setAuthenticatorName("simple");
            authenticatorConfig.setAuthenticatorContext(authenticatorContext);
            authenticator = new SimpleAuthenticator();
            authenticator.init(authenticatorConfig);
            this.register(authenticator);
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        GenericAuthenticatorConfig[] configs = null;
        configs = AuthenticatorConfigBuilder.getAuthenticatorConfigs(new Hashtable(ctx.getEnvironment()));
        int ii = 0;
        while (ii < configs.length) {
            try {
                configs[ii].setAuthenticatorContext(authenticatorContext);
                String authenticatorClass = configs[ii].getAuthenticatorClass();
                Class<?> clazz = Class.forName(authenticatorClass);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                AbstractAuthenticator authenticator = (AbstractAuthenticator)constructor.newInstance(new Object[0]);
                authenticator.init(configs[ii]);
                this.register(authenticator);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++ii;
        }
    }

    public void destroy() {
        this.authenticators.clear();
    }

    public void register(Authenticator authenticator) {
        ArrayList<Authenticator> authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            authenticatorList = new ArrayList<Authenticator>();
            this.authenticators.put(authenticator.getAuthenticatorType(), authenticatorList);
        }
        authenticatorList.add(authenticator);
    }

    public void unregister(Authenticator authenticator) {
        Collection authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            return;
        }
        authenticatorList.remove(authenticator);
    }

    public Collection getAuthenticators(String type) {
        return (Collection)this.authenticators.get(type);
    }

    public void process(NextInterceptor nextProcessor, Invocation call) throws NamingException {
        ServerLdapContext ctx = (ServerLdapContext)call.getContextStack().peek();
        if (ctx.getPrincipal() != null) {
            if (ctx.getEnvironment().containsKey(CREDS)) {
                ctx.removeFromEnvironment(CREDS);
            }
            nextProcessor.process(call);
            return;
        }
        String authList = (String)ctx.getEnvironment().get(AUTH_TYPE);
        if (authList == null) {
            authList = ctx.getEnvironment().containsKey(CREDS) ? "simple" : "none";
        }
        authList = StringTools.deepTrim(authList);
        String[] auth = authList.split(" ");
        Collection authenticators = null;
        int i = 0;
        while (i < auth.length) {
            authenticators = this.getAuthenticators(auth[i]);
            if (authenticators != null) break;
            ++i;
        }
        if (authenticators == null) {
            ctx.getEnvironment();
            ResultCodeEnum rc = ResultCodeEnum.AUTHMETHODNOTSUPPORTED;
            throw new LdapAuthenticationNotSupportedException(rc);
        }
        Iterator i2 = authenticators.iterator();
        while (i2.hasNext()) {
            try {
                Authenticator authenticator = (Authenticator)i2.next();
                LdapPrincipal authorizationId = authenticator.authenticate(ctx);
                ctx.setPrincipal(new TrustedPrincipalWrapper(authorizationId));
                ctx.removeFromEnvironment(CREDS);
                nextProcessor.process(call);
                return;
            }
            catch (LdapAuthenticationException ldapAuthenticationException) {}
        }
        throw new LdapAuthenticationException();
    }

    public final class TrustedPrincipalWrapper {
        private final LdapPrincipal principal;

        private TrustedPrincipalWrapper(LdapPrincipal principal) {
            this.principal = principal;
        }

        public LdapPrincipal getPrincipal() {
            return this.principal;
        }
    }
}

