/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.authn;

import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.ldap.common.util.StringTools;
import org.apache.ldap.server.authn.GenericAuthenticatorConfig;

public class AuthenticatorConfigBuilder {
    private static final GenericAuthenticatorConfig[] EMPTY = new GenericAuthenticatorConfig[0];

    public static GenericAuthenticatorConfig getAuthenticatorConfig(String authenticatorName, Hashtable env) throws NamingException {
        StringBuffer buf = new StringBuffer();
        GenericAuthenticatorConfig config = new GenericAuthenticatorConfig();
        config.setAuthenticatorName(authenticatorName);
        buf.setLength(0);
        buf.append("server.authenticator.class.").append(authenticatorName);
        String authenticatorClass = (String)env.get(buf.toString());
        if (authenticatorClass != null) {
            config.setAuthenticatorClass(authenticatorClass);
        }
        buf.setLength(0);
        buf.append("server.authenticator.properties.").append(authenticatorName);
        String propertiesFile = (String)env.get(buf.toString());
        if (propertiesFile != null) {
            try {
                Properties properties = config.getProperties();
                properties.load(new FileInputStream(propertiesFile));
                config.setProperties(properties);
            }
            catch (Exception e) {
                throw new NamingException(e.getMessage());
            }
        }
        return config;
    }

    public static GenericAuthenticatorConfig[] getAuthenticatorConfigs(Hashtable env) throws NamingException {
        String idList = (String)env.get("server.authenticators");
        if (idList == null || idList.trim().length() == 0) {
            return EMPTY;
        }
        idList = StringTools.deepTrim(idList);
        String[] ids = idList.split(" ");
        GenericAuthenticatorConfig[] configs = new GenericAuthenticatorConfig[ids.length];
        int ii = 0;
        while (ii < configs.length) {
            configs[ii] = AuthenticatorConfigBuilder.getAuthenticatorConfig(ids[ii], env);
            ++ii;
        }
        return configs;
    }
}

