/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.ldap.server.db.NoDupsEnumeration;
import org.apache.ldap.server.db.Tuple;

public class DupsEnumeration
implements NamingEnumeration {
    private boolean hasMore = true;
    private final Tuple returned = new Tuple();
    private final Tuple prefetched = new Tuple();
    private final NoDupsEnumeration underlying;
    private Tuple duplicates;
    private Iterator dupIterator;

    public DupsEnumeration(NoDupsEnumeration list) throws NamingException {
        this.underlying = list;
        if (!this.underlying.hasMore()) {
            this.close();
            return;
        }
        this.prefetch();
    }

    public Object next() throws NamingException {
        this.returned.setKey(this.prefetched.getKey());
        this.returned.setValue(this.prefetched.getValue());
        this.prefetch();
        return this.returned;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public void close() {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        while (this.dupIterator == null || !this.dupIterator.hasNext()) {
            if (this.underlying.hasMore()) {
                this.duplicates = (Tuple)this.underlying.next();
                TreeSet set = (TreeSet)this.duplicates.getValue();
                if (this.underlying.doAscendingScan()) {
                    this.dupIterator = set.iterator();
                    continue;
                }
                ArrayList list = new ArrayList(set.size());
                list.addAll(set);
                Collections.reverse(list);
                this.dupIterator = list.iterator();
                continue;
            }
            this.close();
            return;
        }
        this.prefetched.setKey(this.duplicates.getKey());
        this.prefetched.setValue(this.dupIterator.next());
    }
}

